/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Defaults
implements CrankstartCommand {
    public static final String I_DEFAULTS = "defaults";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public String getDescription() {
        return "defaults: set the default value of a crankstart variable";
    }

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_DEFAULTS.equals(commandLine.getVerb());
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        String[] parts = commandLine.getQualifier().split(" ");
        String key = parts[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(parts[i]);
        }
        String value = sb.toString();
        crankstartContext.getDefaults().put(key, value);
        this.log.info("[{}] has default value [{}]", (Object)key, (Object)value);
    }
}

