/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sling.commons.threads.ThreadPoolConfig;

public final class ExtendedThreadFactory
implements ThreadFactory {
    private static final String THREAD_NAME_TEMPLATE = "sling-%s-%d";
    private final ThreadFactory factory;
    private final String name;
    private final int priority;
    private final boolean isDaemon;
    private final AtomicInteger threadCounter;

    public ExtendedThreadFactory(ThreadFactory factory, String name, ThreadPoolConfig.ThreadPriority priority, boolean isDaemon) {
        this.factory = factory;
        this.name = this.normalizeName(name);
        this.priority = this.convertPriority(priority);
        this.isDaemon = isDaemon;
        this.threadCounter = new AtomicInteger(1);
    }

    private String normalizeName(String name) {
        String n = name.toLowerCase(Locale.ENGLISH).replaceAll("\\s+", "-");
        return ExtendedThreadFactory.stripPrefixes(n, "apache-sling-", "sling-");
    }

    private int convertPriority(ThreadPoolConfig.ThreadPriority priority) {
        if (priority == null) {
            throw new IllegalStateException("Prioriy must not be null.");
        }
        switch (priority) {
            case MIN: {
                return 1;
            }
            case MAX: {
                return 10;
            }
        }
        return 5;
    }

    @Override
    public Thread newThread(Runnable command) {
        Thread thread = this.factory.newThread(command);
        thread.setName(this.nextThreadName());
        thread.setPriority(this.priority);
        thread.setDaemon(this.isDaemon);
        return thread;
    }

    private String nextThreadName() {
        return String.format(THREAD_NAME_TEMPLATE, this.name, this.threadCounter.getAndIncrement());
    }

    private static String stripPrefixes(String name, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            return name.substring(prefix.length());
        }
        return name;
    }
}

