/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=checkpoint"})
public class CheckpointOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(CheckpointOperation.class);

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        try {
            String path = request.getResource().getPath();
            response.setPath(path);
            ArrayList<Modification> changes = new ArrayList<Modification>();
            this.doRun(request, response, changes);
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            log.debug("Saving changes...");
            request.getResourceResolver().commit();
            HashMap<String, String> modificationSourcesContainingPostfix = new HashMap<String, String>();
            HashSet<String> allModificationSources = new HashSet<String>(changes.size());
            for (Modification modification : changes) {
                String source = modification.getSource();
                if (source == null) continue;
                allModificationSources.add(source);
                int atIndex = source.indexOf(64);
                if (atIndex <= 0) continue;
                modificationSourcesContainingPostfix.put(source.substring(0, atIndex), source);
            }
        }
        catch (Exception e) {
            log.error("Exception during response processing.", (Throwable)e);
            response.setError((Throwable)e);
        }
    }

    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws PersistenceException {
        try {
            Resource resource = request.getResource();
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) {
                response.setStatus(404, "Missing source " + resource + " for checkpoint");
                return;
            }
            log.debug("Adding checkpoint for Node {}", (Object)node.getPath());
            node.getSession().getWorkspace().getVersionManager().checkpoint(node.getPath());
            changes.add(Modification.onCheckin((String)resource.getPath()));
            changes.add(Modification.onCheckout((String)resource.getPath()));
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }
}

