/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.redisson.v3;

import io.netty.channel.Channel;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.redisson.v3.RedissonPluginConfig;
import org.apache.skywalking.apm.plugin.redisson.v3.util.ClassUtil;
import org.apache.skywalking.apm.util.StringUtil;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;

public class RedisConnectionMethodInterceptor
implements InstanceMethodsAroundInterceptorV2,
InstanceConstructorInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(RedisConnectionMethodInterceptor.class);
    private static final String ABBR = "...";
    private static final String QUESTION_MARK = "?";
    private static final String DELIMITER_SPACE = " ";
    public static final Object STOP_SPAN_FLAG = new Object();

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        String peer = (String)objInst.getSkyWalkingDynamicField();
        RedisConnection connection = (RedisConnection)objInst;
        Channel channel = connection.getChannel();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        String dbInstance = remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        String operationName = "Redisson/";
        String command = "";
        Object[] arguments = new Object[]{};
        if (allArguments[0] instanceof CommandsData) {
            operationName = operationName + "BATCH_EXECUTE";
            command = "BATCH_EXECUTE";
            if (RedissonPluginConfig.Plugin.Redisson.SHOW_BATCH_COMMANDS) {
                command = command + ":" + this.showBatchCommands((CommandsData)allArguments[0]);
            }
        } else if (allArguments[0] instanceof CommandData) {
            CommandData commandData = (CommandData)allArguments[0];
            command = commandData.getCommand().getName();
            if ("PING".equals(command) && !RedissonPluginConfig.Plugin.Redisson.SHOW_PING_COMMAND) {
                return;
            }
            operationName = operationName + command;
            arguments = commandData.getParams();
        }
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (String)peer);
        context.setContext(STOP_SPAN_FLAG);
        span.setComponent((Component)ComponentsDefine.REDISSON);
        Tags.CACHE_TYPE.set(span, "Redis");
        Tags.CACHE_INSTANCE.set(span, dbInstance);
        Tags.CACHE_CMD.set(span, command);
        this.getKey(arguments).ifPresent(key -> Tags.CACHE_KEY.set(span, key));
        this.parseOperation(command.toLowerCase()).ifPresent(op -> Tags.CACHE_OP.set(span, op));
        SpanLayer.asCache((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) throws Throwable {
        if (Objects.nonNull(context.getContext())) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
        if (Objects.nonNull(context.getContext())) {
            AbstractSpan span = ContextManager.activeSpan();
            span.log(t);
        }
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        String peer = (String)((EnhancedInstance)allArguments[0]).getSkyWalkingDynamicField();
        if (peer == null) {
            try {
                Object address = ClassUtil.getObjectField(((RedisClient)allArguments[0]).getConfig(), "address");
                String host = (String)ClassUtil.getObjectField(address, "host");
                String port = String.valueOf(ClassUtil.getObjectField(address, "port"));
                peer = host + ":" + port;
            }
            catch (Exception e) {
                LOGGER.warn("RedisConnection create peer error: ", new Object[]{e});
            }
        }
        objInst.setSkyWalkingDynamicField((Object)peer);
    }

    private Optional<String> getKey(Object[] allArguments) {
        if (!RedissonPluginConfig.Plugin.Redisson.TRACE_REDIS_PARAMETERS) {
            return Optional.empty();
        }
        if (allArguments.length == 0) {
            return Optional.empty();
        }
        Object argument = allArguments[0];
        if (!(argument instanceof String)) {
            return Optional.empty();
        }
        return Optional.of(StringUtil.cut((String)((String)argument), (int)RedissonPluginConfig.Plugin.Redisson.REDIS_PARAMETER_MAX_LENGTH));
    }

    private Optional<String> parseOperation(String cmd) {
        if (RedissonPluginConfig.Plugin.Redisson.OPERATION_MAPPING_READ.contains(cmd)) {
            return Optional.of("read");
        }
        if (RedissonPluginConfig.Plugin.Redisson.OPERATION_MAPPING_WRITE.contains(cmd)) {
            return Optional.of("write");
        }
        return Optional.empty();
    }

    private String showBatchCommands(CommandsData commandsData) {
        return commandsData.getCommands().stream().map(data -> data.getCommand().getName()).collect(Collectors.joining(";"));
    }
}

