/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.shared.Numerics;

final class LinearlyDerivedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = -2172866644024476121L;
    private final Vector base;
    private final double scale;
    private final double offset;

    LinearlyDerivedVector(Vector base, double scale, double offset) {
        this.base = base;
        this.scale = scale;
        this.offset = offset;
        assert (Double.isFinite(scale) && scale != 0.0) : scale;
        assert (Double.isFinite(offset)) : offset;
    }

    public Class<Double> getElementType() {
        return Double.class;
    }

    @Override
    public boolean isSinglePrecision() {
        return false;
    }

    @Override
    public boolean isInteger() {
        if (Numerics.isInteger(this.scale) && Numerics.isInteger(this.offset) && this.base.isInteger()) {
            return true;
        }
        return super.isInteger();
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmptyOrNaN() {
        return this.base.isEmptyOrNaN();
    }

    @Override
    public boolean isNaN(int index) {
        return this.base.isNaN(index);
    }

    @Override
    public double doubleValue(int index) {
        return Math.fma(this.base.doubleValue(index), this.scale, this.offset);
    }

    @Override
    public String stringValue(int index) {
        return Double.toString(this.doubleValue(index));
    }

    @Override
    public Number get(int index) {
        return this.doubleValue(index);
    }

    @Override
    public Number set(int index, Number value) {
        return this.convert(this.base.set(index, this.inverse(value)));
    }

    @Override
    public void fill(int fromIndex, int toIndex, Number value) {
        this.base.fill(fromIndex, toIndex, this.inverse(value));
    }

    @Override
    final int indexOf(int toSearch, int index, boolean equality) {
        return this.base.indexOf(toSearch, index, equality);
    }

    @Override
    public int[] repetitions(int ... candidates) {
        return this.base.repetitions(candidates);
    }

    @Override
    public Number increment(double tolerance) {
        Number inc = this.base.increment(tolerance / this.scale);
        if (inc != null && this.scale != 1.0) {
            inc = inc.doubleValue() * this.scale;
        }
        return inc;
    }

    private Number convert(Number value) {
        if (value != null) {
            value = Math.fma(value.doubleValue(), this.scale, this.offset);
        }
        return value;
    }

    private Number inverse(Number value) {
        if (value != null) {
            value = (value.doubleValue() - this.offset) / this.scale;
        }
        return value;
    }

    private NumberRange<?> convert(NumberRange<?> range) {
        if (range != null) {
            Number min = (Number)range.getMinValue();
            Number max = (Number)range.getMaxValue();
            boolean bl = !Objects.equals(min, min = this.convert(min));
            Number number = max;
            if (bl | !Objects.equals(number, max = this.convert(max))) {
                boolean isMinIncluded = range.isMinIncluded();
                boolean isMaxIncluded = range.isMaxIncluded();
                if (this.scale < 0.0) {
                    Number tv = min;
                    min = max;
                    max = tv;
                    boolean ti = isMinIncluded;
                    isMinIncluded = isMaxIncluded;
                    isMaxIncluded = ti;
                }
                range = new NumberRange<Double>(Double.class, Numbers.cast(min, Double.class), isMinIncluded, Numbers.cast(max, Double.class), isMaxIncluded);
            }
        }
        return range;
    }

    @Override
    public NumberRange<?> range() {
        return this.convert(this.base.range());
    }

    @Override
    final NumberRange<?> range(IntSupplier indices, int n) {
        return this.convert(this.base.range(indices, n));
    }

    @Override
    public Vector subSampling(int first, int step, int length) {
        return new LinearlyDerivedVector(this.base.subSampling(first, step, length), this.scale, this.offset);
    }

    @Override
    public Vector pick(int ... indices) {
        return new LinearlyDerivedVector(this.base.pick(indices), this.scale, this.offset);
    }

    @Override
    final Vector createConcatenate(Vector toAppend) {
        if (toAppend instanceof LinearlyDerivedVector) {
            LinearlyDerivedVector d = (LinearlyDerivedVector)toAppend;
            if (d.scale == this.scale && d.offset == this.offset) {
                return new LinearlyDerivedVector(this.base.concatenate(d.base), this.scale, this.offset);
            }
        }
        return super.createConcatenate(toAppend);
    }

    @Override
    final Vector createTransform(double s, double t) {
        return this.base.transform(this.scale * s, Math.fma(this.offset, s, t));
    }

    @Override
    public double[] doubleValues() {
        double[] array = this.base.doubleValues();
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.fma(array[i], this.scale, this.offset);
        }
        return array;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LinearlyDerivedVector) {
            LinearlyDerivedVector d = (LinearlyDerivedVector)object;
            if (d.scale == this.scale && d.offset == this.offset) {
                return this.base.equals(d.base);
            }
        }
        return super.equals(object);
    }

    @Override
    boolean equals(int lower, int upper, Vector other, int otherOffset) {
        if (other instanceof LinearlyDerivedVector) {
            LinearlyDerivedVector d = (LinearlyDerivedVector)other;
            if (d.scale == this.scale && d.offset == this.offset) {
                return this.base.equals(lower, upper, d.base, otherOffset);
            }
        }
        return super.equals(lower, upper, other, otherOffset);
    }
}

