/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.setup;

import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.lite.internal.setup.JobClassNameProvider;

public final class DefaultJobClassNameProvider
implements JobClassNameProvider {
    private static final String LAMBDA_CHARACTERISTICS = "$$Lambda$";

    @Override
    public String getJobClassName(ElasticJob elasticJob) {
        Class<?> elasticJobClass = elasticJob.getClass();
        String elasticJobClassName = elasticJobClass.getName();
        return this.isLambdaClass(elasticJobClass) ? this.trimLambdaClassSuffix(elasticJobClassName) : elasticJobClassName;
    }

    private boolean isLambdaClass(Class<? extends ElasticJob> elasticJobClass) {
        return elasticJobClass.isSynthetic() && elasticJobClass.getSimpleName().contains(LAMBDA_CHARACTERISTICS);
    }

    private String trimLambdaClassSuffix(String className) {
        return className.substring(0, className.lastIndexOf(LAMBDA_CHARACTERISTICS) + LAMBDA_CHARACTERISTICS.length());
    }
}

