/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.repository.impl;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.shardingsphere.elasticjob.lite.ui.exception.JobConsoleException;
import org.apache.shardingsphere.elasticjob.lite.ui.repository.XmlRepository;
import org.apache.shardingsphere.elasticjob.lite.ui.util.HomeFolderUtils;

public abstract class AbstractXmlRepositoryImpl<E>
implements XmlRepository<E> {
    private final File file;
    private final Class<E> clazz;
    private final JAXBContext jaxbContext;

    protected AbstractXmlRepositoryImpl(String fileName, Class<E> clazz) {
        this.file = new File(HomeFolderUtils.getFilePathInHomeFolder(fileName));
        this.clazz = clazz;
        HomeFolderUtils.createHomeFolderIfNotExisted();
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException ex) {
            throw new JobConsoleException(500, ex.getMessage());
        }
    }

    @Override
    public synchronized E load() {
        if (!this.file.exists()) {
            try {
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new JobConsoleException(500, ex.getMessage());
            }
        }
        try {
            return (E)this.jaxbContext.createUnmarshaller().unmarshal(this.file);
        }
        catch (JAXBException ex) {
            throw new JobConsoleException(500, ex.getMessage());
        }
    }

    @Override
    public synchronized void save(E entity) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(entity, this.file);
        }
        catch (JAXBException ex) {
            throw new JobConsoleException(500, ex.getMessage());
        }
    }
}

