/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.faultinjection.FaultInjectionConfig;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class FaultInjectionUtil {
    private static final Map<String, AtomicLong> requestCount = new ConcurrentHashMapEx();
    private static final Map<String, AtomicInteger> configCenterValue = new ConcurrentHashMapEx();

    private FaultInjectionUtil() {
    }

    public static AtomicLong getOperMetTotalReq(String key) {
        return requestCount.computeIfAbsent(key, p -> new AtomicLong(1L));
    }

    public static Map<String, AtomicInteger> getConfigCenterMap() {
        return configCenterValue;
    }

    public static void setConfigCenterValue(String key, AtomicInteger value) {
        configCenterValue.put(key, value);
    }

    public static int getFaultInjectionConfig(Invocation invocation, String key) {
        int value = 0;
        String operationName = invocation.getOperationName();
        String schema = invocation.getSchemaId();
        String serviceName = invocation.getMicroserviceName();
        String config = "servicecomb.governance.Consumer." + serviceName + ".schemas." + schema + ".operations." + operationName + ".policy.fault.protocols." + invocation.getTransport().getName() + "." + key;
        value = FaultInjectionUtil.getConfigValue(config);
        if (value != -1) {
            return value;
        }
        config = "servicecomb.governance.Consumer." + serviceName + ".schemas." + schema + ".policy.fault.protocols." + invocation.getTransport().getName() + "." + key;
        value = FaultInjectionUtil.getConfigValue(config);
        if (value != -1) {
            return value;
        }
        config = "servicecomb.governance.Consumer." + serviceName + ".policy.fault.protocols." + invocation.getTransport().getName() + "." + key;
        value = FaultInjectionUtil.getConfigValue(config);
        if (value != -1) {
            return value;
        }
        config = "servicecomb.governance.Consumer._global.policy.fault.protocols." + invocation.getTransport().getName() + "." + key;
        value = FaultInjectionUtil.getConfigValue(config);
        return value;
    }

    private static int getConfigValue(String config) {
        int value = 0;
        Map<String, AtomicInteger> cfgMap = FaultInjectionUtil.getConfigCenterMap();
        if (cfgMap.containsKey(config)) {
            return cfgMap.get(config).get();
        }
        value = FaultInjectionConfig.getConfigVal(config, -1);
        return value;
    }

    public static boolean isFaultNeedToInject(long reqCount, int percentage) {
        long resultNew = reqCount * (long)percentage / 100L;
        long resultOld = (reqCount - 1L) * (long)percentage / 100L;
        return resultNew != resultOld;
    }

    @VisibleForTesting
    static Map<String, AtomicLong> getRequestCount() {
        return requestCount;
    }

    @VisibleForTesting
    static Map<String, AtomicInteger> getConfigCenterValue() {
        return configCenterValue;
    }
}

