/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.remote;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.GeoReferencedArray;

class CoverageDataResponse
implements CoordSysContainer {
    public List<CoverageCoordAxis> axes;
    public List<CoverageCoordSys> coordSys;
    public List<CoverageTransform> transforms;
    public List<GeoReferencedArray> arrayResponse;

    public CoverageDataResponse(List<CoverageCoordAxis> axes, List<CoverageCoordSys> coordSys, List<CoverageTransform> transforms) {
        this.axes = axes;
        this.coordSys = coordSys;
        this.transforms = transforms;
        this.arrayResponse = new ArrayList<GeoReferencedArray>();
        for (CoverageCoordSys csys : coordSys) {
            csys.setDataset(this);
            csys.setHorizCoordSys(csys.makeHorizCoordSys());
        }
    }

    public CoverageCoordSys findCoordSys(String csysName) {
        for (CoverageCoordSys csys : this.coordSys) {
            if (!csys.getName().equalsIgnoreCase(csysName)) continue;
            return csys;
        }
        return null;
    }

    @Override
    public CoverageTransform findCoordTransform(String transformName) {
        for (CoverageTransform ct : this.transforms) {
            if (!ct.getName().equalsIgnoreCase(transformName)) continue;
            return ct;
        }
        return null;
    }

    @Override
    public CoverageCoordAxis findCoordAxis(String axisName) {
        for (CoverageCoordAxis axis : this.axes) {
            if (!axis.getName().equalsIgnoreCase(axisName)) continue;
            return axis;
        }
        return null;
    }
}

