/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;

public class AlbersEqualArea
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "albers_conical_equal_area";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double[] pars = this.readAttributeDouble2(ctv.findAttribute("standard_parallel"));
        if (pars == null) {
            return null;
        }
        this.readStandardParams(ctv, geoCoordinateUnits);
        ProjectionImpl proj = this.earth != null ? new AlbersEqualAreaEllipse(this.lat0, this.lon0, pars[0], pars[1], this.false_easting, this.false_northing, this.earth) : new ucar.unidata.geoloc.projection.AlbersEqualArea(this.lat0, this.lon0, pars[0], pars[1], this.false_easting, this.false_northing, this.earth_radius);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

