/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.sedona.common.raster.serde.DataBufferSerializer;
import org.apache.sedona.common.raster.serde.SampleModelSerializer;

public class AWTRasterSerializer
extends Serializer<Raster> {
    private static final SampleModelSerializer sampleModelSerializer = new SampleModelSerializer();
    private static final DataBufferSerializer dataBufferSerializer = new DataBufferSerializer();

    public void write(Kryo kryo, Output output, Raster raster) {
        Raster r;
        if (raster.getParent() != null) {
            r = raster.createCompatibleWritableRaster(raster.getBounds());
            ((WritableRaster)r).setRect(raster);
        } else {
            r = raster;
        }
        output.writeInt(r.getMinX());
        output.writeInt(r.getMinY());
        sampleModelSerializer.write(kryo, output, r.getSampleModel());
        dataBufferSerializer.write(kryo, output, r.getDataBuffer());
    }

    public Raster read(Kryo kryo, Input input, Class<Raster> type) {
        int minX = input.readInt();
        int minY = input.readInt();
        Point location = new Point(minX, minY);
        Object sampleModel = sampleModelSerializer.read(kryo, input, (Class)SampleModel.class);
        Object dataBuffer = dataBufferSerializer.read(kryo, input, (Class)DataBuffer.class);
        return Raster.createRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, location);
    }
}

