/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.unidata.util.Parameter;

@ThreadSafe
public class CoordinateTransform
implements Comparable<CoordinateTransform> {
    private volatile int hashCode;
    protected String name;
    protected String authority;
    protected final TransformType transformType;
    protected List<Parameter> params;
    private AttributeContainerMutable attributeContainer;

    protected CoordinateTransform(String name, String authority, TransformType transformType, List<Parameter> params) {
        this.name = name;
        this.authority = authority;
        this.transformType = transformType;
        this.params = ImmutableList.copyOf(params);
    }

    @Deprecated
    public CoordinateTransform(String name, String authority, TransformType transformType) {
        this.name = name;
        this.authority = authority;
        this.transformType = transformType;
        this.params = new ArrayList<Parameter>();
    }

    @Deprecated
    public void addParameter(Parameter param) {
        this.params.add(param);
    }

    public String getName() {
        return this.name;
    }

    public AttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    public String getAuthority() {
        return this.authority;
    }

    public TransformType getTransformType() {
        return this.transformType;
    }

    public ImmutableList<Parameter> getParameters() {
        return ImmutableList.copyOf(this.params);
    }

    public Parameter findParameterIgnoreCase(String name) {
        for (Parameter a : this.params) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof CoordinateTransform)) {
            return false;
        }
        CoordinateTransform o = (CoordinateTransform)oo;
        if (!this.getName().equals(o.getName())) {
            return false;
        }
        if (!this.getAuthority().equals(o.getAuthority())) {
            return false;
        }
        if (this.getTransformType() != o.getTransformType()) {
            return false;
        }
        ImmutableList<Parameter> oparams = o.getParameters();
        if (this.params.size() != oparams.size()) {
            return false;
        }
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter att = this.params.get(i);
            Parameter oatt = (Parameter)oparams.get(i);
            if (att.getName().equals(oatt.getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getAuthority().hashCode();
            result = 37 * result + this.getTransformType().hashCode();
            for (Parameter att : this.params) {
                result = 37 * result + att.getName().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CoordinateTransform oct) {
        return this.name.compareTo(oct.getName());
    }

    protected CoordinateTransform(Builder<?> builder, NetcdfDataset ncd) {
        this.name = builder.name;
        this.authority = ((Builder)builder).authority;
        this.transformType = ((Builder)builder).transformType;
        this.attributeContainer = new AttributeContainerMutable(this.name);
        this.attributeContainer.addAll(((Builder)builder).attributeContainer);
        CoordinateTransform ct = CoordTransBuilder.makeCoordinateTransform(ncd, ((Builder)builder).attributeContainer, new Formatter(), new Formatter());
        ct.attributeContainer = new AttributeContainerMutable(this.name);
        ct.attributeContainer.addAll(((Builder)builder).attributeContainer);
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(CoordinateTransform.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return ((Builder)((Builder)b.setName(this.name).setAuthority(this.authority)).setTransformType(this.transformType)).setAttributeContainer(this.attributeContainer);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>> {
        public String name;
        private String authority;
        private TransformType transformType;
        private AttributeContainer attributeContainer;
        private CoordinateTransform preBuilt;
        private boolean built;

        protected abstract T self();

        public T setName(String name) {
            this.name = name;
            return this.self();
        }

        public T setAuthority(String authority) {
            this.authority = authority;
            return this.self();
        }

        public T setTransformType(TransformType transformType) {
            this.transformType = transformType;
            return this.self();
        }

        public T setAttributeContainer(AttributeContainer attributeContainer) {
            this.attributeContainer = attributeContainer;
            return this.self();
        }

        public T setPreBuilt(CoordinateTransform preBuilt) {
            this.preBuilt = preBuilt;
            this.name = preBuilt.name;
            return this.self();
        }

        public CoordinateTransform build(NetcdfDataset ncd) {
            if (this.built) {
                throw new IllegalStateException("already built " + this.name);
            }
            this.built = true;
            if (this.preBuilt != null) {
                return this.preBuilt;
            }
            CoordinateTransform ct = CoordTransBuilder.makeCoordinateTransform(ncd, this.attributeContainer, new Formatter(), new Formatter());
            if (ct != null) {
                ct.attributeContainer = new AttributeContainerMutable(this.name);
                ct.attributeContainer.addAll(this.attributeContainer);
            }
            return ct;
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

