/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.proj4.CylindricalEqualAreaProjection;

public class LambertCylindricalEqualArea
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "lambert_cylindrical_equal_area";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double par = this.readAttributeDouble(ctv, "standard_parallel", Double.NaN);
        this.readStandardParams(ctv, geoCoordinateUnits);
        if (this.earth == null) {
            this.earth = this.earth_radius > 0.0 ? new Earth(this.earth_radius * 1000.0) : new Earth();
        }
        CylindricalEqualAreaProjection proj = new CylindricalEqualAreaProjection(this.lon0, par, this.false_easting, this.false_northing, this.earth);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

