/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geometrySerde;

import org.apache.sedona.common.geometrySerde.ByteBufferGeometryBuffer;
import org.apache.sedona.common.geometrySerde.GeometryBuffer;
import org.apache.sedona.common.geometrySerde.UnsafeGeometryBuffer;

public class GeometryBufferFactory {
    private static boolean enableUnsafeGeometryBuffer = true;

    public static void toggleUnsafeGeometryBuffer(boolean enabled) {
        enableUnsafeGeometryBuffer = enabled;
    }

    public static GeometryBuffer create(int bufferSize) {
        if (UnsafeGeometryBuffer.isUnsafeAvailable() && enableUnsafeGeometryBuffer) {
            return new UnsafeGeometryBuffer(bufferSize);
        }
        return new ByteBufferGeometryBuffer(bufferSize);
    }

    public static GeometryBuffer create(String bufferType, int bufferSize) {
        switch (bufferType) {
            case "bytebuffer": {
                return new ByteBufferGeometryBuffer(bufferSize);
            }
            case "unsafe": {
                return new UnsafeGeometryBuffer(bufferSize);
            }
        }
        throw new IllegalArgumentException("Unknown buffer type: " + bufferType);
    }

    public static GeometryBuffer wrap(byte[] bytes) {
        if (UnsafeGeometryBuffer.isUnsafeAvailable() && enableUnsafeGeometryBuffer) {
            return new UnsafeGeometryBuffer(bytes);
        }
        return new ByteBufferGeometryBuffer(bytes);
    }

    public static GeometryBuffer wrap(String bufferType, byte[] bytes) {
        switch (bufferType) {
            case "bytebuffer": {
                return new ByteBufferGeometryBuffer(bytes);
            }
            case "unsafe": {
                return new UnsafeGeometryBuffer(bytes);
            }
        }
        throw new IllegalArgumentException("Unknown buffer type: " + bufferType);
    }
}

