/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.MigrationState;
import java.io.IOException;
import java.util.Objects;

public class MigrationStateImpl
implements MigrationState,
IdentifiedDataSerializable {
    private long startTime;
    private int plannedMigrations;
    private int completedMigrations;
    private long totalElapsedTime;

    public MigrationStateImpl() {
    }

    public MigrationStateImpl(long startTime, int plannedMigrations, int completedMigrations, long totalElapsedTime) {
        this.startTime = startTime;
        this.plannedMigrations = plannedMigrations;
        this.completedMigrations = completedMigrations;
        this.totalElapsedTime = totalElapsedTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPlannedMigrations() {
        return this.plannedMigrations;
    }

    @Override
    public int getCompletedMigrations() {
        return this.completedMigrations;
    }

    @Override
    public int getRemainingMigrations() {
        return this.plannedMigrations - this.completedMigrations;
    }

    @Override
    public long getTotalElapsedTime() {
        return this.totalElapsedTime;
    }

    public MigrationStateImpl onComplete(long elapsed) {
        return this.onComplete(1, elapsed);
    }

    public MigrationStateImpl onComplete(int migrations, long elapsed) {
        return new MigrationStateImpl(this.startTime, this.plannedMigrations, this.completedMigrations + migrations, this.totalElapsedTime + elapsed);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.startTime);
        out.writeLong(this.totalElapsedTime);
        out.writeInt(this.plannedMigrations);
        out.writeInt(this.completedMigrations);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.startTime = in.readLong();
        this.totalElapsedTime = in.readLong();
        this.plannedMigrations = in.readInt();
        this.completedMigrations = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    public String toString() {
        return "MigrationState{startTime=" + this.startTime + ", plannedMigrations=" + this.plannedMigrations + ", completedMigrations=" + this.completedMigrations + ", totalElapsedTime=" + this.totalElapsedTime + "ms}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrationStateImpl)) {
            return false;
        }
        MigrationStateImpl that = (MigrationStateImpl)o;
        return this.startTime == that.startTime && this.plannedMigrations == that.plannedMigrations && this.completedMigrations == that.completedMigrations && this.totalElapsedTime == that.totalElapsedTime;
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.plannedMigrations, this.completedMigrations, this.totalElapsedTime);
    }
}

