/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.state;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.spi.impl.InternalCompletableFuture;

public class LeadershipTransferState {
    private int term;
    private RaftEndpoint endpoint;
    private InternalCompletableFuture resultFuture;

    LeadershipTransferState(int term, RaftEndpoint endpoint, InternalCompletableFuture resultFuture) {
        this.term = term;
        this.endpoint = endpoint;
        this.resultFuture = resultFuture;
    }

    public int term() {
        return this.term;
    }

    public RaftEndpoint endpoint() {
        return this.endpoint;
    }

    public boolean complete(Object value) {
        if (value instanceof Throwable) {
            return this.resultFuture.completeExceptionally((Throwable)value);
        }
        return this.resultFuture.complete(value);
    }

    public void notify(RaftEndpoint targetEndpoint, InternalCompletableFuture otherFuture) {
        if (this.endpoint.equals(targetEndpoint)) {
            this.resultFuture.whenCompleteAsync(InternalCompletableFuture.completingCallback(otherFuture));
        } else {
            otherFuture.completeExceptionally(new IllegalStateException("There is an ongoing leadership transfer process to " + this.endpoint));
        }
    }
}

