/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Unit;

public class ThreadSafeCounter
implements Counter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private static final AtomicLongFieldUpdater<ThreadSafeCounter> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(ThreadSafeCounter.class, "value");
    private volatile long value;

    public ThreadSafeCounter(String name) {
        this.name = name;
    }

    @Override
    public void inc() {
        VOLATILE_VALUE_UPDATER.incrementAndGet(this);
    }

    @Override
    public void inc(long n) {
        VOLATILE_VALUE_UPDATER.addAndGet(this, n);
    }

    @Override
    public void dec() {
        VOLATILE_VALUE_UPDATER.decrementAndGet(this);
    }

    @Override
    public void dec(long n) {
        VOLATILE_VALUE_UPDATER.addAndGet(this, -n);
    }

    @Override
    public void set(long n) {
        VOLATILE_VALUE_UPDATER.set(this, n);
    }

    @Override
    public long getCount() {
        return VOLATILE_VALUE_UPDATER.get(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Unit unit() {
        return Unit.COUNT;
    }

    public String toString() {
        return "ThreadSafeCounter{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

