/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.RoleTypeEnum;
import org.apache.seatunnel.app.dal.dao.IRoleDao;
import org.apache.seatunnel.app.dal.dao.IRoleUserRelationDao;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.apache.seatunnel.app.dal.entity.Role;
import org.apache.seatunnel.app.dal.entity.RoleUserRelation;
import org.apache.seatunnel.app.dal.entity.User;
import org.apache.seatunnel.app.service.IRoleService;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements IRoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Resource
    private IRoleDao roleDaoImpl;
    @Resource
    private IRoleUserRelationDao roleUserRelationDaoImpl;
    @Resource
    private IUserDao userDaoImpl;

    @Override
    public boolean addUserToRole(Integer userId, Integer type) {
        String roleName = type.intValue() == RoleTypeEnum.ADMIN.getCode() ? RoleTypeEnum.ADMIN.getDescription() : RoleTypeEnum.NORMAL.getDescription();
        Role role = this.roleDaoImpl.getByRoleName(roleName);
        RoleUserRelation build = RoleUserRelation.builder().roleId(role.getId()).userId(userId).build();
        this.roleUserRelationDaoImpl.add(build);
        return true;
    }

    @Override
    public boolean checkUserRole(String username, String roleName) {
        User user = this.userDaoImpl.getByName(username);
        Preconditions.checkState((!Objects.isNull(user) ? 1 : 0) != 0, (Object)SeatunnelErrorEnum.NO_SUCH_USER.getTemplate());
        Role role = this.roleDaoImpl.getByRoleName(roleName);
        RoleUserRelation byUserAndRole = this.roleUserRelationDaoImpl.getByUserAndRole(user.getId(), role.getId());
        return !Objects.isNull(byUserAndRole);
    }

    @Override
    public void deleteByUserId(Integer userId) {
        this.roleUserRelationDaoImpl.deleteByUserId(userId);
    }
}

