/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.bean.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.app.domain.response.connector.ConnectorFeature;
import org.apache.seatunnel.app.domain.response.connector.ConnectorInfo;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.framework.PluginDiscoveryUtil;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.config.DeployMode;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.stereotype.Component;

@Component
public class ConnectorCache {
    private final ConcurrentMap<PluginType, List<ConnectorInfo>> downloadConnectorCache = new ConcurrentHashMap<PluginType, List<ConnectorInfo>>();
    private final ConcurrentMap<PluginType, List<ConnectorInfo>> allConnectorCache = new ConcurrentHashMap<PluginType, List<ConnectorInfo>>();
    private final ConcurrentMap<PluginIdentifier, OptionRule> allConnectorOptionRule = new ConcurrentHashMap<PluginIdentifier, OptionRule>();
    private List<ConnectorInfo> transformCache = new CopyOnWriteArrayList<ConnectorInfo>();
    private ConcurrentMap<String, FormStructure> sourceFormStructureCache = new ConcurrentHashMap<String, FormStructure>();
    private ConcurrentMap<String, FormStructure> sinkFormStructureCache = new ConcurrentHashMap<String, FormStructure>();
    private ConcurrentMap<String, FormStructure> transformFormStructureCache = new ConcurrentHashMap<String, FormStructure>();
    private Map<PluginIdentifier, ConnectorFeature> featureMap = new HashMap<PluginIdentifier, ConnectorFeature>();

    public ConnectorCache() throws IOException {
        this.refresh();
    }

    public List<ConnectorInfo> getAllConnectors(PluginType pluginType) {
        return (List)this.allConnectorCache.get(pluginType);
    }

    public List<ConnectorInfo> getTransform() {
        return this.transformCache;
    }

    public List<ConnectorInfo> getDownLoadConnector(PluginType pluginType) {
        return (List)this.downloadConnectorCache.get(pluginType);
    }

    public List<ConnectorInfo> getNotDownLoadConnector(PluginType pluginType) {
        Map allConnectors = ((List)this.allConnectorCache.get(pluginType)).stream().collect(Collectors.toMap(ConnectorInfo::getPluginIdentifier, Function.identity()));
        ((List)this.downloadConnectorCache.get(pluginType)).forEach(d -> {
            ConnectorInfo cfr_ignored_0 = (ConnectorInfo)allConnectors.remove(d.getPluginIdentifier());
        });
        return new ArrayList<ConnectorInfo>(allConnectors.values());
    }

    public ConnectorFeature getConnectorFeature(PluginIdentifier connectorInfo) {
        return this.featureMap.get(connectorInfo);
    }

    public synchronized void refresh() throws IOException {
        Common.setDeployMode((DeployMode)DeployMode.CLIENT);
        Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> allConnectors = PluginDiscoveryUtil.getAllConnectors();
        this.allConnectorOptionRule.clear();
        allConnectors.forEach((key, value) -> this.allConnectorOptionRule.putAll((Map<PluginIdentifier, OptionRule>)value));
        this.downloadConnectorCache.put(PluginType.SOURCE, PluginDiscoveryUtil.getDownloadedConnectors(allConnectors, PluginType.SOURCE));
        this.downloadConnectorCache.put(PluginType.SINK, PluginDiscoveryUtil.getDownloadedConnectors(allConnectors, PluginType.SINK));
        this.allConnectorCache.put(PluginType.SOURCE, PluginDiscoveryUtil.getAllConnectorsFromPluginMapping(PluginType.SOURCE));
        this.allConnectorCache.put(PluginType.SINK, PluginDiscoveryUtil.getAllConnectorsFromPluginMapping(PluginType.SINK));
        this.transformCache = PluginDiscoveryUtil.getTransforms(allConnectors);
        this.sourceFormStructureCache = PluginDiscoveryUtil.getDownloadedConnectorFormStructures(allConnectors, PluginType.SOURCE);
        this.sinkFormStructureCache = PluginDiscoveryUtil.getDownloadedConnectorFormStructures(allConnectors, PluginType.SINK);
        this.transformFormStructureCache = PluginDiscoveryUtil.getTransformFormStructures(allConnectors);
        this.syncSourceFeature();
    }

    private void syncSourceFeature() throws IOException {
        this.featureMap = PluginDiscoveryUtil.getConnectorFeatures(PluginType.SOURCE);
    }

    public FormStructure getFormStructure(@NonNull String pluginType, @NonNull String connectorName) {
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        if (PluginType.SOURCE.getType().equals(pluginType)) {
            return (FormStructure)this.sourceFormStructureCache.get(connectorName);
        }
        if (PluginType.TRANSFORM.getType().equals(pluginType)) {
            return (FormStructure)this.transformFormStructureCache.get(connectorName);
        }
        if (PluginType.SINK.getType().equals(pluginType)) {
            return (FormStructure)this.sinkFormStructureCache.get(connectorName);
        }
        throw new SeatunnelException(SeatunnelErrorEnum.UNSUPPORTED_CONNECTOR_TYPE, new Object[]{pluginType});
    }

    public OptionRule getOptionRule(@NonNull String pluginType, @NonNull String connectorName) {
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        return (OptionRule)this.allConnectorOptionRule.get(PluginIdentifier.of((String)"seatunnel", (String)pluginType, (String)connectorName));
    }
}

