/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomConfigPlaceholder {
    public static final String REPLACE_PLACEHOLDER_MODEL = "model";
    public static final String REPLACE_PLACEHOLDER_INPUT = "input";
    public static final String REPLACE_PLACEHOLDER_PROMPT = "prompt";

    public static String replacePlaceholders(String input, String placeholderName, String value, String defaultValue) {
        String placeholderRegex = "\\$\\{" + Pattern.quote(placeholderName) + "(:[^}]*)?\\}";
        Pattern pattern = Pattern.compile(placeholderRegex);
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String string = value != null && !value.isEmpty() ? value : (replacement = matcher.group(1) != null ? matcher.group(1).substring(1).trim() : defaultValue);
            if (replacement == null) continue;
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static Boolean findPlaceholder(String input, String placeholderName) {
        String placeholderRegex = "\\$\\{" + Pattern.quote(placeholderName) + "(:[^}]*)?\\}";
        Pattern pattern = Pattern.compile(placeholderRegex);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }
}

