/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.config.AbstractYamlConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.config.yaml.YamlDomChecker;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfigSections;
import org.apache.seatunnel.engine.common.config.YamlSeaTunnelConfigLocator;
import org.apache.seatunnel.engine.common.config.YamlSeaTunnelDomConfigProcessor;
import org.w3c.dom.Node;

public class YamlSeaTunnelConfigBuilder
extends AbstractYamlConfigBuilder {
    private final InputStream in;

    public YamlSeaTunnelConfigBuilder() {
        this((YamlSeaTunnelConfigLocator)null);
    }

    public YamlSeaTunnelConfigBuilder(YamlSeaTunnelConfigLocator locator) {
        if (locator == null) {
            locator = new YamlSeaTunnelConfigLocator();
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
    }

    public YamlSeaTunnelConfigBuilder(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        this.in = inputStream;
    }

    protected String getConfigRoot() {
        return SeaTunnelConfigSections.SEATUNNEL.name;
    }

    public SeaTunnelConfig build() {
        return this.build(new SeaTunnelConfig());
    }

    public SeaTunnelConfig build(SeaTunnelConfig config) {
        try {
            this.parseAndBuildConfig(config);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        config.setHazelcastConfig(ConfigProvider.locateAndGetMemberConfig(this.getProperties()));
        return config;
    }

    private void parseAndBuildConfig(SeaTunnelConfig config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load((InputStream)this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", (Throwable)ex);
        }
        finally {
            IOUtil.closeResource((Closeable)this.in);
        }
        YamlMapping seatunnelRoot = yamlRootNode.childAsMapping(SeaTunnelConfigSections.SEATUNNEL.name);
        if (seatunnelRoot == null) {
            seatunnelRoot = yamlRootNode;
        }
        YamlDomChecker.check((YamlNode)seatunnelRoot);
        Node w3cRootNode = W3cDomUtil.asW3cNode((YamlNode)seatunnelRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments((YamlNode)seatunnelRoot);
        new YamlSeaTunnelDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    public YamlSeaTunnelConfigBuilder setProperties(Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        this.setPropertiesInternal(properties);
        return this;
    }
}

