/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.collection;

import com.hazelcast.collection.ItemListener;
import com.hazelcast.collection.impl.collection.CollectionEventFilter;
import com.hazelcast.collection.impl.collection.operations.CollectionAddAllOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionAddOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionClearOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionCompareAndRemoveOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionContainsOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionGetAllOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionIsEmptyOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionRemoveOperation;
import com.hazelcast.collection.impl.collection.operations.CollectionSizeOperation;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.InitializingObject;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.SerializableList;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public abstract class AbstractCollectionProxyImpl<S extends RemoteService, E>
extends AbstractDistributedObject<S>
implements InitializingObject {
    protected final String name;
    protected final int partitionId;

    protected AbstractCollectionProxyImpl(String name, NodeEngine nodeEngine, S service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public void initialize() {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionConfig config = this.getConfig(nodeEngine);
        ConfigValidator.checkCollectionConfig(config, nodeEngine.getSplitBrainMergePolicyProvider());
        List<ItemListenerConfig> itemListenerConfigs = config.getItemListenerConfigs();
        for (ItemListenerConfig itemListenerConfig : itemListenerConfigs) {
            ItemListener listener = itemListenerConfig.getImplementation();
            if (listener == null && itemListenerConfig.getClassName() != null) {
                try {
                    listener = (ItemListener)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), itemListenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            this.addItemListener(listener, itemListenerConfig.isIncludeValue());
        }
    }

    protected abstract CollectionConfig getConfig(NodeEngine var1);

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public boolean add(@Nonnull E e) {
        Preconditions.checkNotNull(e, "Null item is not allowed");
        Data value = this.getNodeEngine().toData(e);
        CollectionAddOperation operation = new CollectionAddOperation(this.name, value);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public boolean remove(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        Data value = this.getNodeEngine().toData(o);
        CollectionRemoveOperation operation = new CollectionRemoveOperation(this.name, value);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public int size() {
        CollectionSizeOperation operation = new CollectionSizeOperation(this.name);
        Integer result = (Integer)this.invoke(operation);
        return result;
    }

    public boolean isEmpty() {
        CollectionIsEmptyOperation operation = new CollectionIsEmptyOperation(this.name);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public boolean contains(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        CollectionContainsOperation operation = new CollectionContainsOperation(this.name, Collections.singleton(this.getNodeEngine().toData(o)));
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Set<Data> valueSet = SetUtil.createHashSet(c.size());
        NodeEngine nodeEngine = this.getNodeEngine();
        for (Object o : c) {
            Preconditions.checkNotNull(o, "Null collection element is not allowed");
            valueSet.add(nodeEngine.toData(o));
        }
        CollectionContainsOperation operation = new CollectionContainsOperation(this.name, valueSet);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        NodeEngine nodeEngine = this.getNodeEngine();
        for (E e : c) {
            Preconditions.checkNotNull(e, "Null collection element is not allowed");
            valueList.add(nodeEngine.toData(e));
        }
        CollectionAddAllOperation operation = new CollectionAddAllOperation(this.name, valueList);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.compareAndRemove(true, c);
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        return this.compareAndRemove(false, c);
    }

    private boolean compareAndRemove(boolean retain, @Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Set<Data> valueSet = SetUtil.createHashSet(c.size());
        NodeEngine nodeEngine = this.getNodeEngine();
        for (Object o : c) {
            Preconditions.checkNotNull(o, "Null collection element is not allowed");
            valueSet.add(nodeEngine.toData(o));
        }
        CollectionCompareAndRemoveOperation operation = new CollectionCompareAndRemoveOperation(this.name, retain, valueSet);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    public void clear() {
        CollectionClearOperation operation = new CollectionClearOperation(this.name);
        this.invoke(operation);
    }

    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.getAll()).iterator();
    }

    public Object[] toArray() {
        return this.getAll().toArray();
    }

    public <T> T[] toArray(@Nonnull T[] a) {
        Preconditions.checkNotNull(a, "Null array parameter is not allowed!");
        return this.getAll().toArray(a);
    }

    private Collection<E> getAll() {
        CollectionGetAllOperation operation = new CollectionGetAllOperation(this.name);
        SerializableList result = (SerializableList)this.invoke(operation);
        List<Data> collection = result.getCollection();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        return new UnmodifiableLazyList(collection, serializationService);
    }

    @Nonnull
    public UUID addItemListener(@Nonnull ItemListener<E> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        EventService eventService = this.getNodeEngine().getEventService();
        CollectionEventFilter filter = new CollectionEventFilter(includeValue);
        EventRegistration registration = eventService.registerListener(this.getServiceName(), this.name, filter, listener);
        return registration.getId();
    }

    public boolean removeItemListener(@Nonnull UUID registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.deregisterListener(this.getServiceName(), this.name, registrationId);
    }

    protected <T> T invoke(CollectionOperation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            InvocationFuture f = nodeEngine.getOperationService().invokeOnPartition(this.getServiceName(), operation, this.partitionId);
            return nodeEngine.toObject(f.get());
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected void checkIndexNotNegative(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is negative");
        }
    }
}

