/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.cluster.Address;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seatunnel.engine.server.resourcemanager.AbstractResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.NoEnoughResourceException;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.RequestSlotOperation;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.engine.server.service.slot.SlotAndWorkerProfile;

public class ResourceRequestHandler {
    private static final ILogger LOGGER = Logger.getLogger(ResourceRequestHandler.class);
    private final CompletableFuture<List<SlotProfile>> completableFuture = new CompletableFuture();
    private final ConcurrentMap<Integer, SlotProfile> resultSlotProfiles = new ConcurrentHashMap<Integer, SlotProfile>();
    private final ConcurrentMap<Address, WorkerProfile> registerWorker;
    private static final int MAX_RETRY_TIMES = 3;
    private final long jobId;
    private final List<ResourceProfile> resourceProfile;
    private final AbstractResourceManager resourceManager;

    public ResourceRequestHandler(long jobId, List<ResourceProfile> resourceProfile, ConcurrentMap<Address, WorkerProfile> registerWorker, AbstractResourceManager resourceManager) {
        this.jobId = jobId;
        this.resourceProfile = resourceProfile;
        this.registerWorker = registerWorker;
        this.resourceManager = resourceManager;
    }

    public CompletableFuture<List<SlotProfile>> request(Map<String, String> tags) {
        this.requestSlotWithRetry(this.resourceProfile, 3, tags);
        return this.completableFuture;
    }

    private CompletableFuture<SlotAndWorkerProfile> requestSlotWithRetry(List<ResourceProfile> request, int retryTimes, Map<String, String> tags) {
        if (retryTimes <= 0) {
            LOGGER.fine("can't apply resource request with retry times: 3");
            return CompletableFuture.supplyAsync(() -> {
                throw new NoEnoughResourceException("can't apply resource request with retry times: 3");
            });
        }
        List allRequestFuture = this.requestSlots(request);
        return this.getAllOfFuture(allRequestFuture).whenComplete(ExceptionUtil.withTryCatch(LOGGER, (unused, error) -> {
            if (error != null) {
                this.completeRequestWithException((Throwable)error);
            } else {
                List<ResourceProfile> needRequestResource = this.stillNeedRequestResource();
                if (!needRequestResource.isEmpty()) {
                    Exception requestSlotWithRetryError = null;
                    try {
                        this.requestSlotWithRetry(needRequestResource, retryTimes - 1, tags).get();
                    }
                    catch (Exception e) {
                        LOGGER.warning("request slot with retry error: " + e.getMessage());
                        requestSlotWithRetryError = e;
                    }
                    if (requestSlotWithRetryError != null) {
                        if (this.resourceManager.supportDynamicWorker()) {
                            this.applyByDynamicWorker(tags);
                        } else {
                            this.completeRequestWithException(requestSlotWithRetryError);
                        }
                    }
                }
            }
        }));
    }

    private List<ResourceProfile> stillNeedRequestResource() {
        ArrayList<ResourceProfile> needRequestResource = new ArrayList<ResourceProfile>();
        for (int i = 0; i < this.resourceProfile.size(); ++i) {
            if (this.resultSlotProfiles.containsKey(i)) continue;
            needRequestResource.add(this.resourceProfile.get(i));
        }
        return needRequestResource;
    }

    private List<CompletableFuture<SlotAndWorkerProfile>> requestSlots(List<ResourceProfile> requestProfile) {
        ArrayList<CompletableFuture<SlotAndWorkerProfile>> allRequestFuture = new ArrayList<CompletableFuture<SlotAndWorkerProfile>>();
        for (int i = 0; i < requestProfile.size(); ++i) {
            ResourceProfile r = requestProfile.get(i);
            Optional<WorkerProfile> workerProfile = this.preCheckWorkerResource(r);
            if (workerProfile.isPresent()) {
                CompletableFuture<SlotAndWorkerProfile> internalCompletableFuture = this.singleResourceRequestToMember(i, r, workerProfile.get());
                allRequestFuture.add(internalCompletableFuture);
                continue;
            }
            LOGGER.fine("pre check worker resource failed, can't apply resource request: " + r);
            allRequestFuture.add(CompletableFuture.supplyAsync(() -> {
                throw new NoEnoughResourceException("can't apply resource request: " + r);
            }));
        }
        return allRequestFuture;
    }

    private void completeRequestWithException(Throwable e) {
        this.releaseAllResourceInternal();
        this.completableFuture.completeExceptionally(e);
    }

    private void addSlotToCacheMap(int index, SlotProfile slotProfile) {
        if (null != slotProfile) {
            this.resultSlotProfiles.put(index, slotProfile);
            if (this.resultSlotProfiles.size() == this.resourceProfile.size()) {
                ArrayList<SlotProfile> value = new ArrayList<SlotProfile>();
                for (int i = 0; i < this.resultSlotProfiles.size(); ++i) {
                    value.add((SlotProfile)this.resultSlotProfiles.get(i));
                }
                this.completableFuture.complete(value);
            }
        } else {
            LOGGER.fine("no suitable slot found for resource: " + this.resourceProfile.get(index));
        }
    }

    private CompletableFuture<SlotAndWorkerProfile> singleResourceRequestToMember(int i, ResourceProfile r, WorkerProfile workerProfile) {
        CompletableFuture future = this.resourceManager.sendToMember(new RequestSlotOperation(this.jobId, r), workerProfile.getAddress());
        return future.whenComplete(ExceptionUtil.withTryCatch(LOGGER, (slotAndWorkerProfile, error) -> {
            if (error != null) {
                throw new RuntimeException((Throwable)error);
            }
            this.resourceManager.heartbeat(slotAndWorkerProfile.getWorkerProfile());
            this.addSlotToCacheMap(i, slotAndWorkerProfile.getSlotProfile());
        }));
    }

    @VisibleForTesting
    public Optional<WorkerProfile> preCheckWorkerResource(ResourceProfile r) {
        List<WorkerProfile> workerProfiles = Arrays.asList(this.registerWorker.values().toArray(new WorkerProfile[0]));
        Collections.shuffle(workerProfiles);
        Optional<WorkerProfile> workerProfile = workerProfiles.stream().filter(worker -> Arrays.stream(worker.getUnassignedSlots()).anyMatch(slot -> slot.getResourceProfile().enoughThan(r))).findAny();
        if (!workerProfile.isPresent()) {
            workerProfile = workerProfiles.stream().filter(WorkerProfile::isDynamicSlot).filter(worker -> worker.getUnassignedResource().enoughThan(r)).findAny();
        }
        return workerProfile;
    }

    private void applyByDynamicWorker(Map<String, String> tags) {
        ArrayList<ResourceProfile> needApplyResource = new ArrayList<ResourceProfile>();
        ArrayList<Integer> needApplyIndex = new ArrayList<Integer>();
        for (int i = 0; i < this.resultSlotProfiles.size(); ++i) {
            if (this.resultSlotProfiles.containsKey(i)) continue;
            needApplyResource.add(this.resourceProfile.get(i));
            needApplyIndex.add(i);
        }
        this.resourceManager.findNewWorker(needApplyResource, tags);
        this.resourceManager.applyResources(this.jobId, needApplyResource, tags).whenComplete(ExceptionUtil.withTryCatch(LOGGER, (s2, e) -> {
            if (e != null) {
                this.completeRequestWithException((Throwable)e);
                return;
            }
            for (int i = 0; i < s2.size(); ++i) {
                this.addSlotToCacheMap((Integer)needApplyIndex.get(i), (SlotProfile)s2.get(i));
            }
        }));
    }

    private void releaseAllResourceInternal() {
        LOGGER.warning("apply resource not success, release all already applied resource");
        new ArrayList(this.resultSlotProfiles.keySet()).forEach(index -> {
            SlotProfile profile = (SlotProfile)this.resultSlotProfiles.remove(index);
            if (profile != null) {
                this.resourceManager.releaseResource(this.jobId, profile);
            }
        });
    }

    private <T> CompletableFuture<T> getAllOfFuture(List<CompletableFuture<T>> allRequestFuture) {
        return CompletableFuture.allOf(allRequestFuture.toArray(new CompletableFuture[0]));
    }
}

