/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class CreateIndexDeParser
extends AbstractDeParser<CreateIndex> {
    public CreateIndexDeParser(StringBuilder buffer) {
        super(buffer);
    }

    @Override
    public void deParse(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        this.buffer.append("CREATE ");
        if (index.getType() != null) {
            this.buffer.append(index.getType());
            this.buffer.append(" ");
        }
        this.buffer.append("INDEX ");
        this.buffer.append(index.getName());
        this.buffer.append(" ON ");
        this.buffer.append(createIndex.getTable().getFullyQualifiedName());
        String using = index.getUsing();
        if (using != null) {
            this.buffer.append(" USING ");
            this.buffer.append(using);
        }
        if (index.getColumnsNames() != null) {
            this.buffer.append(" (");
            this.buffer.append(index.getColumnWithParams().stream().map(cp -> cp.columnName + (cp.getParams() != null ? " " + String.join((CharSequence)" ", cp.getParams()) : "")).collect(Collectors.joining(", ")));
            this.buffer.append(")");
        }
        if (createIndex.getTailParameters() != null) {
            for (String param2 : createIndex.getTailParameters()) {
                this.buffer.append(" ").append(param2);
            }
        }
    }
}

