/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import com.hazelcast.map.IMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.job.RefCount;

public class SharedConnectorJarCleanupTask
extends TimerTask {
    private final Consumer<ConnectorJarIdentifier> cleanupCallback;
    private final IMap<ConnectorJarIdentifier, RefCount> connectorJarRefCounters;

    public SharedConnectorJarCleanupTask(Consumer<ConnectorJarIdentifier> cleanupCallback, IMap<ConnectorJarIdentifier, RefCount> connectorJarRefCounters) {
        this.cleanupCallback = (Consumer)Preconditions.checkNotNull(cleanupCallback);
        this.connectorJarRefCounters = (IMap)Preconditions.checkNotNull(connectorJarRefCounters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        IMap<ConnectorJarIdentifier, RefCount> iMap = this.connectorJarRefCounters;
        synchronized (iMap) {
            for (Map.Entry<ConnectorJarIdentifier, RefCount> entry : this.connectorJarRefCounters.entrySet()) {
                if (entry.getValue().getReferences() > 0L) continue;
                ConnectorJarIdentifier connectorJarIdentifier = entry.getKey();
                this.cleanupCallback.accept(connectorJarIdentifier);
            }
        }
    }
}

