/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

public final class FloatConverter
extends Converter {
    public static final FloatConverter INSTANCE = new FloatConverter();

    private FloatConverter() {
        super(7, QueryDataTypeFamily.REAL);
    }

    @Override
    public Class<?> getValueClass() {
        return Float.class;
    }

    @Override
    public byte asTinyint(Object val) {
        float val0 = this.cast(val);
        if (Float.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.TINYINT);
        }
        if (Float.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.TINYINT);
        }
        byte converted = (byte)val0;
        if (converted != (int)val0) {
            throw this.numericOverflowError(QueryDataTypeFamily.TINYINT);
        }
        return converted;
    }

    @Override
    public short asSmallint(Object val) {
        float val0 = this.cast(val);
        if (Float.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.SMALLINT);
        }
        if (Float.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.SMALLINT);
        }
        short converted = (short)val0;
        if (converted != (int)val0) {
            throw this.numericOverflowError(QueryDataTypeFamily.SMALLINT);
        }
        return converted;
    }

    @Override
    public int asInt(Object val) {
        float val0 = this.cast(val);
        if (Float.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.INTEGER);
        }
        if (Float.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.INTEGER);
        }
        int converted = (int)val0;
        if ((long)converted != (long)val0) {
            throw this.numericOverflowError(QueryDataTypeFamily.INTEGER);
        }
        return converted;
    }

    @Override
    public long asBigint(Object val) {
        float val0 = this.cast(val);
        if (Float.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.BIGINT);
        }
        if (Float.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.BIGINT);
        }
        float truncated = (float)((double)val0 > 0.0 ? Math.floor(val0) : Math.ceil(val0));
        long converted = (long)truncated;
        if ((float)converted != truncated) {
            throw this.numericOverflowError(QueryDataTypeFamily.BIGINT);
        }
        return converted;
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        float val0 = this.cast(val);
        if (Float.isInfinite(val0)) {
            throw this.infiniteValueError(QueryDataTypeFamily.DECIMAL);
        }
        if (Float.isNaN(val0)) {
            throw this.nanValueError(QueryDataTypeFamily.DECIMAL);
        }
        return new BigDecimal(val0, ExpressionMath.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val);
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Float.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return Float.valueOf(valConverter.asReal(val));
    }

    private float cast(Object val) {
        return ((Float)val).floatValue();
    }
}

