/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.config.MapConfigReadOnly;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GetMapConfigOperation
extends AbstractLocalOperation {
    private final String mapName;
    private MapConfig mapConfig;

    public GetMapConfigOperation(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public void run() throws Exception {
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        MapContainer mapContainer = mapServiceContext.getMapContainer(this.mapName);
        MapConfig readOnlyMapConfig = mapContainer.getMapConfig();
        List<IndexConfig> indexConfigs = this.getIndexConfigsFromContainer(mapContainer);
        if (indexConfigs.isEmpty()) {
            this.mapConfig = readOnlyMapConfig;
        } else {
            MapConfig enrichedConfig = new MapConfig(readOnlyMapConfig);
            enrichedConfig.setIndexConfigs(indexConfigs);
            this.mapConfig = new MapConfigReadOnly(enrichedConfig);
        }
    }

    @Override
    public Object getResponse() {
        return this.mapConfig;
    }

    private List<IndexConfig> getIndexConfigsFromContainer(MapContainer mapContainer) {
        Indexes indexes = mapContainer.getIndexes();
        if (indexes != null) {
            return Arrays.stream(indexes.getIndexes()).map(Index::getConfig).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

