/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.common.env.EnvironmentUtil;
import org.apache.seatunnel.engine.common.env.Version;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.operation.GetClusterHealthMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobStatusOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.GetOverviewOperation;
import org.apache.seatunnel.engine.server.resourcemanager.resource.OverviewInfo;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class RestHttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private static final String SOURCE_RECEIVED_COUNT = "SourceReceivedCount";
    private static final String TABLE_SOURCE_RECEIVED_COUNT = "TableSourceReceivedCount";
    private static final String SINK_WRITE_COUNT = "SinkWriteCount";
    private static final String TABLE_SINK_WRITE_COUNT = "TableSinkWriteCount";
    private final Log4j2HttpGetCommandProcessor original;
    private NodeEngine nodeEngine;

    public RestHttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpGetCommandProcessor(textCommandService));
    }

    public RestHttpGetCommandProcessor(TextCommandService textCommandService, Log4j2HttpGetCommandProcessor log4j2HttpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = log4j2HttpGetCommandProcessor;
    }

    @Override
    public void handle(HttpGetCommand httpGetCommand) {
        String uri = httpGetCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/running-jobs")) {
                this.handleRunningJobsInfo(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/finished-jobs")) {
                this.handleFinishedJobsInfo(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-job") || uri.startsWith("/hazelcast/rest/maps/job-info")) {
                this.handleJobInfoById(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/system-monitoring-information")) {
                this.getSystemMonitoringInformation(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-threads")) {
                this.getRunningThread(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/overview")) {
                this.overView(httpGetCommand, uri);
            } else {
                this.original.handle(httpGetCommand);
            }
        }
        catch (IndexOutOfBoundsException e) {
            httpGetCommand.send400();
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpGetCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse(e));
        }
        this.textCommandService.sendResponse(httpGetCommand);
    }

    @Override
    public void handleRejection(HttpGetCommand httpGetCommand) {
        this.handle(httpGetCommand);
    }

    public void overView(HttpGetCommand command, String uri) {
        OverviewInfo overviewInfo;
        String tagStr;
        if ((uri = StringUtil.stripTrailingSlash(uri)).contains("?")) {
            int index = uri.indexOf("?");
            tagStr = uri.substring(index + 1);
        } else {
            tagStr = "";
        }
        Map<String, String> tags = Arrays.stream(tagStr.split("&")).map(variable -> variable.split("=", 2)).filter(pair -> ((String[])pair).length == 2).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
        Version version = EnvironmentUtil.getVersion();
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        if (seaTunnelServer == null) {
            overviewInfo = (OverviewInfo)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetOverviewOperation(tags)).join();
            overviewInfo.setProjectVersion(version.getProjectVersion());
            overviewInfo.setGitCommitAbbrev(version.getGitCommitAbbrev());
        } else {
            NodeEngineImpl nodeEngine = this.textCommandService.getNode().getNodeEngine();
            overviewInfo = GetOverviewOperation.getOverviewInfo(seaTunnelServer, nodeEngine, tags);
            overviewInfo.setProjectVersion(version.getProjectVersion());
            overviewInfo.setGitCommitAbbrev(version.getGitCommitAbbrev());
        }
        this.prepareResponse(command, JsonUtil.toJsonObject(JsonUtils.toMap(JsonUtils.toJsonString(overviewInfo))));
    }

    private void getSystemMonitoringInformation(HttpGetCommand command) {
        Cluster cluster = this.textCommandService.getNode().hazelcastInstance.getCluster();
        this.nodeEngine = this.textCommandService.getNode().hazelcastInstance.node.nodeEngine;
        Set<Member> members = cluster.getMembers();
        JsonArray jsonValues = members.stream().map(member -> {
            Address address = member.getAddress();
            String input = null;
            try {
                input = (String)NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new GetClusterHealthMetricsOperation(), address).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("get system monitoring information fail", e);
            }
            String[] parts = input.split(", ");
            JsonObject jobInfo = new JsonObject();
            Arrays.stream(parts).forEach(part -> {
                String[] keyValue = part.split("=");
                jobInfo.add(keyValue[0], keyValue[1]);
            });
            return jobInfo;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jsonValues);
    }

    private void handleRunningJobsInfo(HttpGetCommand command) {
        IMap values = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        JsonArray jobs = values.entrySet().stream().map(jobInfoEntry -> this.convertToJson((JobInfo)jobInfoEntry.getValue(), (Long)jobInfoEntry.getKey())).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private void handleFinishedJobsInfo(HttpGetCommand command, String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash(uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        String state = indexEnd == -1 ? "" : uri.substring(indexEnd + 1);
        IMap finishedJob = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState");
        IMap finishedJobMetrics = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics");
        IMap finishedJobDAGInfo = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo");
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        JsonArray jobs = finishedJob.values().stream().filter(jobState -> {
            if (state.isEmpty()) {
                return true;
            }
            return jobState.getJobStatus().name().equals(state.toUpperCase());
        }).sorted(Comparator.comparing(JobHistoryService.JobState::getFinishTime)).map(jobState -> {
            Long jobId = jobState.getJobId();
            String jobMetrics = seaTunnelServer == null ? (String)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join() : seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            return this.getJobInfoJson((JobHistoryService.JobState)jobState, jobMetrics, (JobDAGInfo)finishedJobDAGInfo.get(jobId));
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private void handleJobInfoById(HttpGetCommand command, String uri) {
        uri = StringUtil.stripTrailingSlash(uri);
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String jobId = uri.substring(indexEnd + 1);
        IMap jobInfoMap = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        JobInfo jobInfo = (JobInfo)jobInfoMap.get(Long.valueOf(jobId));
        IMap finishedJobStateMap = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState");
        JobHistoryService.JobState finishedJobState = (JobHistoryService.JobState)finishedJobStateMap.get(Long.valueOf(jobId));
        if (!jobId.isEmpty() && jobInfo != null) {
            this.prepareResponse(command, this.convertToJson(jobInfo, Long.parseLong(jobId)));
        } else if (!jobId.isEmpty() && finishedJobState != null) {
            JobMetrics finishedJobMetrics = (JobMetrics)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics").get(Long.valueOf(jobId));
            JobDAGInfo finishedJobDAGInfo = (JobDAGInfo)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo").get(Long.valueOf(jobId));
            this.prepareResponse(command, this.getJobInfoJson(finishedJobState, finishedJobMetrics.toJsonString(), finishedJobDAGInfo));
        } else {
            this.prepareResponse(command, new JsonObject().add("jobId", jobId));
        }
    }

    private void getRunningThread(HttpGetCommand command) {
        this.prepareResponse(command, Thread.getAllStackTraces().keySet().stream().sorted(Comparator.comparing(Thread::getName)).map(stackTraceElements -> {
            JsonObject jobInfoJson = new JsonObject();
            jobInfoJson.add("threadName", stackTraceElements.getName());
            jobInfoJson.add("classLoader", String.valueOf(stackTraceElements.getContextClassLoader()));
            return jobInfoJson;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add));
    }

    private Map<String, Object> getJobMetrics(String jobMetrics) {
        HashMap<String, Object> metricsMap = new HashMap<String, Object>();
        long sourceReadCount = 0L;
        long sinkWriteCount = 0L;
        HashMap tableSourceReceivedCountMap = new HashMap();
        HashMap tableSinkWriteCountMap = new HashMap();
        try {
            JsonNode jobMetricsStr = new ObjectMapper().readTree(jobMetrics);
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(jobMetricsStr.fieldNames(), 0), false).filter(metricName -> metricName.contains("#")).forEach(metricName -> {
                String tableName = TablePath.of(metricName.split("#")[1]).getFullName();
                if (metricName.startsWith(SOURCE_RECEIVED_COUNT)) {
                    tableSourceReceivedCountMap.put(tableName, jobMetricsStr.get((String)metricName));
                }
                if (metricName.startsWith(SOURCE_RECEIVED_COUNT)) {
                    tableSinkWriteCountMap.put(tableName, jobMetricsStr.get((String)metricName));
                }
            });
            JsonNode sourceReceivedCountJson = jobMetricsStr.get(SOURCE_RECEIVED_COUNT);
            JsonNode sinkWriteCountJson = jobMetricsStr.get(SINK_WRITE_COUNT);
            for (int i = 0; i < jobMetricsStr.get(SOURCE_RECEIVED_COUNT).size(); ++i) {
                JsonNode sourceReader = sourceReceivedCountJson.get(i);
                JsonNode sinkWriter = sinkWriteCountJson.get(i);
                sourceReadCount += sourceReader.get("value").asLong();
                sinkWriteCount += sinkWriter.get("value").asLong();
            }
        }
        catch (NullPointerException | JsonProcessingException e) {
            return metricsMap;
        }
        Map<String, Long> tableSourceReceivedCount = tableSourceReceivedCountMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StreamSupport.stream(((JsonNode)entry.getValue()).spliterator(), false).mapToLong(node -> node.get("value").asLong()).sum()));
        Map<String, Long> tableSinkWriteCount = tableSinkWriteCountMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StreamSupport.stream(((JsonNode)entry.getValue()).spliterator(), false).mapToLong(node -> node.get("value").asLong()).sum()));
        metricsMap.put(SOURCE_RECEIVED_COUNT, sourceReadCount);
        metricsMap.put(SINK_WRITE_COUNT, sinkWriteCount);
        metricsMap.put(TABLE_SOURCE_RECEIVED_COUNT, tableSourceReceivedCount);
        metricsMap.put(TABLE_SINK_WRITE_COUNT, tableSinkWriteCount);
        return metricsMap;
    }

    private SeaTunnelServer getSeaTunnelServer(boolean shouldBeMaster) {
        Map<String, Object> extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
        if (shouldBeMaster && !seaTunnelServer.isMasterNode()) {
            return null;
        }
        return seaTunnelServer;
    }

    private JsonObject convertToJson(JobInfo jobInfo, long jobId) {
        JobStatus jobStatus;
        String jobMetrics;
        JsonObject jobInfoJson = new JsonObject();
        JobImmutableInformation jobImmutableInformation = (JobImmutableInformation)this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(jobInfo.getJobImmutableInformation()));
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        ClassLoaderService classLoaderService = seaTunnelServer == null ? this.getSeaTunnelServer(false).getClassLoaderService() : seaTunnelServer.getClassLoaderService();
        ClassLoader classLoader = classLoaderService.getClassLoader(jobId, jobImmutableInformation.getPluginJarsUrls());
        LogicalDag logicalDag = (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.textCommandService.getNode().getNodeEngine().getSerializationService(), classLoader, jobImmutableInformation.getLogicalDag());
        classLoaderService.releaseClassLoader(jobId, jobImmutableInformation.getPluginJarsUrls());
        if (seaTunnelServer == null) {
            jobMetrics = (String)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join();
            jobStatus = JobStatus.values()[(Integer)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobStatusOperation(jobId)).join()];
        } else {
            jobMetrics = seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            jobStatus = seaTunnelServer.getCoordinatorService().getJobStatus(jobId);
        }
        jobInfoJson.add("jobId", String.valueOf(jobId)).add("jobName", logicalDag.getJobConfig().getName()).add("jobStatus", jobStatus.toString()).add("envOptions", JsonUtil.toJsonObject(logicalDag.getJobConfig().getEnvOptions())).add("createTime", DateTimeUtils.toString(jobImmutableInformation.getCreateTime(), DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("jobDag", logicalDag.getLogicalDagAsJson()).add("pluginJarsUrls", jobImmutableInformation.getPluginJarsUrls().stream().map(url -> {
            JsonObject jarUrl = new JsonObject();
            jarUrl.add("jarPath", url.toString());
            return jarUrl;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add)).add("isStartWithSavePoint", jobImmutableInformation.isStartWithSavePoint()).add("metrics", this.toJsonObject(this.getJobMetrics(jobMetrics)));
        return jobInfoJson;
    }

    private JsonObject toJsonObject(Map<String, Object> jobMetrics) {
        JsonObject members = new JsonObject();
        jobMetrics.forEach((key, value) -> {
            if (value instanceof Map) {
                members.add((String)key, this.toJsonObject((Map)value));
            } else {
                members.add((String)key, value.toString());
            }
        });
        return members;
    }

    private JsonObject getJobInfoJson(JobHistoryService.JobState jobState, String jobMetrics, JobDAGInfo jobDAGInfo) {
        return new JsonObject().add("jobId", String.valueOf(jobState.getJobId())).add("jobName", jobState.getJobName()).add("jobStatus", jobState.getJobStatus().toString()).add("errorMsg", jobState.getErrorMessage()).add("createTime", DateTimeUtils.toString(jobState.getSubmitTime(), DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("finishTime", DateTimeUtils.toString(jobState.getFinishTime(), DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("jobDag", JsonUtils.toJsonString(jobDAGInfo)).add("pluginJarsUrls", new JsonArray()).add("metrics", this.toJsonObject(this.getJobMetrics(jobMetrics)));
    }
}

