/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.alter.AlterSystemOperation;

public class AlterSystemStatement
implements Statement {
    private final AlterSystemOperation operation;
    private final List<String> parameters;

    public AlterSystemStatement(AlterSystemOperation operation, List<String> parameters) {
        this.operation = Objects.requireNonNull(operation, "The ALTER SYSTEM Operation must not be Null");
        this.parameters = Objects.requireNonNull(parameters, "The PARAMETERS List must not be null although it can be empty.");
    }

    public AlterSystemOperation getOperation() {
        return this.operation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    private static void appendParameters(StringBuilder builder, List<String> parameters) {
        for (String s2 : parameters) {
            builder.append(" ").append(s2);
        }
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("ALTER SYSTEM ").append((Object)this.operation);
        AlterSystemStatement.appendParameters(builder, this.parameters);
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

