/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.internal.util.JavaVersion;
import com.hazelcast.internal.util.JavaVm;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ModularJavaUtils {
    private static final ILogger LOGGER = Logger.getLogger(ModularJavaUtils.class);
    private static final PackageAccessRequirement[] NO_REQUIREMENTS = new PackageAccessRequirement[0];

    private ModularJavaUtils() {
    }

    public static String getHazelcastModuleName() {
        if (!JavaVersion.isAtLeast(JavaVersion.JAVA_9)) {
            return null;
        }
        try {
            return ModularJavaUtils.getName(ModularJavaUtils.hazelcastModule());
        }
        catch (Exception e) {
            LOGGER.finest("Getting Hazelcast module name failed", e);
            return null;
        }
    }

    private static Class<?> moduleClass() throws ClassNotFoundException {
        return Class.forName("java.lang.Module");
    }

    public static void checkJavaInternalAccess(ILogger logger) {
        if (logger == null || !JavaVersion.isAtLeast(JavaVersion.JAVA_9)) {
            return;
        }
        TreeMap<String, PackageAccessRequirement[]> moduleRequirements = new TreeMap<String, PackageAccessRequirement[]>();
        moduleRequirements.put("java.base", PackageAccessRequirement.packages(PackageAccessRequirement.export("jdk.internal.ref"), PackageAccessRequirement.open("java.lang"), PackageAccessRequirement.open("sun.nio.ch")));
        moduleRequirements.put("jdk.management", ModularJavaUtils.getJdkManagementRequirements());
        moduleRequirements.put("java.management", PackageAccessRequirement.packages(PackageAccessRequirement.open("sun.management")));
        ModularJavaUtils.checkPackageRequirements(logger, moduleRequirements);
    }

    private static PackageAccessRequirement[] getJdkManagementRequirements() {
        if (JavaVm.CURRENT_VM == JavaVm.OPENJ9) {
            return PackageAccessRequirement.packages(PackageAccessRequirement.open("com.sun.management.internal"), PackageAccessRequirement.open("com.ibm.lang.management.internal"));
        }
        return PackageAccessRequirement.packages(PackageAccessRequirement.open("com.sun.management.internal"));
    }

    static void checkPackageRequirements(ILogger logger, Map<String, PackageAccessRequirement[]> requirements) {
        if (!ModularJavaUtils.hasHazelcastPackageAccess(requirements)) {
            String hazelcastModule = ModularJavaUtils.getHazelcastModuleName();
            if (hazelcastModule == null) {
                hazelcastModule = "ALL-UNNAMED";
            }
            logger.warning("Hazelcast is starting in a Java modular environment (Java 9 and newer) but without proper access to required Java packages. Use additional Java arguments to provide Hazelcast access to Java internal API. The internal API access is used to get the best performance results. Arguments to be used:\n --add-modules java.se" + ModularJavaUtils.createOpenPackageJavaArguments(hazelcastModule, requirements));
        }
    }

    private static boolean hasHazelcastPackageAccess(Map<String, PackageAccessRequirement[]> requirements) {
        try {
            for (Object module : ModularJavaUtils.modules()) {
                PackageAccessRequirement[] packageRequirements;
                for (PackageAccessRequirement req : packageRequirements = requirements.getOrDefault(ModularJavaUtils.getName(module), NO_REQUIREMENTS)) {
                    boolean hasAccess;
                    boolean bl = hasAccess = req.isForReflection() ? ModularJavaUtils.isOpen(module, req.getPackageName()) : ModularJavaUtils.isExported(module, req.getPackageName());
                    if (hasAccess) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.finest("Checking Hazelcast package access", e);
            return false;
        }
        return true;
    }

    private static String getName(Object module) throws ReflectiveOperationException {
        Method methodGetName = ModularJavaUtils.moduleClass().getMethod("getName", new Class[0]);
        return (String)methodGetName.invoke(module, new Object[0]);
    }

    private static boolean isExported(Object module, String packageName) throws ReflectiveOperationException {
        Method methodIsExported = ModularJavaUtils.moduleClass().getMethod("isExported", String.class, ModularJavaUtils.moduleClass());
        return (Boolean)methodIsExported.invoke(module, packageName, ModularJavaUtils.hazelcastModule());
    }

    private static boolean isOpen(Object module, String packageName) throws ReflectiveOperationException {
        Method methodIsOpen = ModularJavaUtils.moduleClass().getMethod("isOpen", String.class, ModularJavaUtils.moduleClass());
        return (Boolean)methodIsOpen.invoke(module, packageName, ModularJavaUtils.hazelcastModule());
    }

    private static Object hazelcastModule() throws ReflectiveOperationException {
        Method methodGetModule = Class.class.getMethod("getModule", new Class[0]);
        return methodGetModule.invoke(Hazelcast.class, new Object[0]);
    }

    private static Set<?> modules() throws ReflectiveOperationException {
        Class<?> classModuleLayer = Class.forName("java.lang.ModuleLayer");
        Method methodBoot = classModuleLayer.getMethod("boot", new Class[0]);
        Method methodModules = classModuleLayer.getMethod("modules", new Class[0]);
        Object moduleLayerBoot = methodBoot.invoke(null, new Object[0]);
        return (Set)methodModules.invoke(moduleLayerBoot, new Object[0]);
    }

    private static String createOpenPackageJavaArguments(String hzModuleName, Map<String, PackageAccessRequirement[]> requirements) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, PackageAccessRequirement[]> moduleEntry : requirements.entrySet()) {
            for (PackageAccessRequirement requirement : moduleEntry.getValue()) {
                sb.append(requirement.isForReflection() ? " --add-opens " : " --add-exports ").append(moduleEntry.getKey()).append("/").append(requirement.packageName).append("=").append(hzModuleName);
            }
        }
        return sb.toString();
    }

    static final class PackageAccessRequirement {
        private final String packageName;
        private final Mode mode;

        private PackageAccessRequirement(Mode mode, String packageName) {
            this.packageName = packageName;
            this.mode = mode;
        }

        static PackageAccessRequirement[] packages(PackageAccessRequirement ... requirements) {
            return requirements;
        }

        static PackageAccessRequirement open(String packageName) {
            return new PackageAccessRequirement(Mode.OPEN, packageName);
        }

        static PackageAccessRequirement export(String packageName) {
            return new PackageAccessRequirement(Mode.EXPORT, packageName);
        }

        public String toString() {
            return "PackageAccessRequirement{packageName='" + this.packageName + '\'' + ", mode=" + (Object)((Object)this.mode) + '}';
        }

        String getPackageName() {
            return this.packageName;
        }

        boolean isForReflection() {
            return this.mode == Mode.OPEN;
        }

        static enum Mode {
            OPEN,
            EXPORT;

        }
    }
}

