/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

class ProcessClosurePrimitivesWithModuleSupport
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType NULL_ARGUMENT_ERROR = DiagnosticType.error((String)"JSC_NULL_ARGUMENT_ERROR", (String)"method \"{0}\" called without an argument");
    static final DiagnosticType EXPECTED_OBJECTLIT_ERROR = DiagnosticType.error((String)"JSC_EXPECTED_OBJECTLIT_ERROR", (String)"method \"{0}\" expected an object literal argument");
    static final DiagnosticType EXPECTED_STRING_ERROR = DiagnosticType.error((String)"JSC_EXPECTED_STRING_ERROR", (String)"method \"{0}\" expected a string argument");
    static final DiagnosticType INVALID_ARGUMENT_ERROR = DiagnosticType.error((String)"JSC_INVALID_ARGUMENT_ERROR", (String)"method \"{0}\" called with invalid argument");
    static final DiagnosticType INVALID_STYLE_ERROR = DiagnosticType.error((String)"JSC_INVALID_CSS_NAME_MAP_STYLE_ERROR", (String)"Invalid CSS name map style {0}");
    static final DiagnosticType TOO_MANY_ARGUMENTS_ERROR = DiagnosticType.error((String)"JSC_TOO_MANY_ARGUMENTS_ERROR", (String)"method \"{0}\" called with more than one argument");
    static final DiagnosticType DUPLICATE_NAMESPACE_ERROR = DiagnosticType.error((String)"JSC_DUPLICATE_NAMESPACE_ERROR", (String)"namespace \"{0}\" cannot be provided twice\nOriginally provided at {1}");
    static final DiagnosticType WEAK_NAMESPACE_TYPE = DiagnosticType.warning((String)"JSC_WEAK_NAMESPACE_TYPE", (String)"Provided symbol declared with type Object. This is rarely useful. For more information see https://github.com/google/closure-compiler/wiki/A-word-about-the-type-Object");
    static final DiagnosticType CLASS_NAMESPACE_ERROR = DiagnosticType.error((String)"JSC_CLASS_NAMESPACE_ERROR", (String)"\"{0}\" cannot be both provided and declared as a class. Try var {0} = class '{'...'}'");
    static final DiagnosticType FUNCTION_NAMESPACE_ERROR = DiagnosticType.error((String)"JSC_FUNCTION_NAMESPACE_ERROR", (String)"\"{0}\" cannot be both provided and declared as a function");
    static final DiagnosticType MISSING_PROVIDE_ERROR = DiagnosticType.error((String)"JSC_MISSING_PROVIDE_ERROR", (String)"required \"{0}\" namespace never provided");
    static final DiagnosticType LATE_PROVIDE_ERROR = DiagnosticType.error((String)"JSC_LATE_PROVIDE_ERROR", (String)"required \"{0}\" namespace not provided yet");
    static final DiagnosticType INVALID_PROVIDE_ERROR = DiagnosticType.error((String)"JSC_INVALID_PROVIDE_ERROR", (String)"\"{0}\" is not a valid {1} qualified name");
    static final DiagnosticType INVALID_DEFINE_NAME_ERROR = DiagnosticType.error((String)"JSC_INVALID_DEFINE_NAME_ERROR", (String)"\"{0}\" is not a valid JS identifier name");
    static final DiagnosticType MISSING_DEFINE_ANNOTATION = DiagnosticType.error((String)"JSC_INVALID_MISSING_DEFINE_ANNOTATION", (String)"Missing @define annotation");
    static final DiagnosticType XMODULE_REQUIRE_ERROR = DiagnosticType.warning((String)"JSC_XMODULE_REQUIRE_ERROR", (String)"namespace \"{0}\" is required in module {2} but provided in module {1}. Is module {2} missing a dependency on module {1}?");
    static final DiagnosticType NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR = DiagnosticType.error((String)"JSC_NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR", (String)"goog.setCssNameMapping only takes an object literal with string values");
    static final DiagnosticType INVALID_CSS_RENAMING_MAP = DiagnosticType.warning((String)"INVALID_CSS_RENAMING_MAP", (String)"Invalid entries in css renaming map: {0}");
    static final DiagnosticType GOOG_BASE_CLASS_ERROR = DiagnosticType.error((String)"JSC_GOOG_BASE_CLASS_ERROR", (String)"incorrect use of goog.base: {0}");
    static final DiagnosticType BASE_CLASS_ERROR = DiagnosticType.error((String)"JSC_BASE_CLASS_ERROR", (String)"incorrect use of {0}.base: {1}");
    static final DiagnosticType CLOSURE_DEFINES_ERROR = DiagnosticType.error((String)"JSC_CLOSURE_DEFINES_ERROR", (String)"Invalid CLOSURE_DEFINES definition");
    static final DiagnosticType INVALID_FORWARD_DECLARE = DiagnosticType.error((String)"JSC_INVALID_FORWARD_DECLARE", (String)"Malformed goog.forwardDeclaration");
    static final DiagnosticType USE_OF_GOOG_BASE = DiagnosticType.disabled((String)"JSC_USE_OF_GOOG_BASE", (String)"goog.base is not compatible with ES5 strict mode.\nPlease use an alternative.\nFor EcmaScript classes use the super keyword. For traditional Closure classes,\nuse the class specific base method instead. For example, for the constructor MyClass:\n   MyClass.base(this, ''constructor'')");
    static final DiagnosticType CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR = DiagnosticType.error((String)"JSC_CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR", (String)"Closure primitive method {0} may not be aliased");
    static final DiagnosticType CLOSURE_CALL_CANNOT_BE_ALIASED_OUTSIDE_MODULE_ERROR = DiagnosticType.error((String)"JSC_CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR", (String)"Closure primitive method {0} may not be aliased  outside a module (ES module, CommonJS module, or goog.module)");
    static final String GOOG = "goog";
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private final Map<String, ProvidedName> providedNames = new LinkedHashMap<String, ProvidedName>();
    private final Set<String> knownClosureSubclasses = new HashSet<String>();
    private final List<UnrecognizedRequire> unrecognizedRequires = new ArrayList<UnrecognizedRequire>();
    private final Set<String> exportedVariables = new HashSet<String>();
    private final CheckLevel requiresLevel;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final List<Node> defineCalls = new ArrayList<Node>();
    private final boolean preserveGoogProvidesAndRequires;
    private final List<Node> requiresToBeRemoved = new ArrayList<Node>();
    private final Set<Node> maybeTemporarilyLiveNodes = new HashSet<Node>();
    private ArrayList<String> externStrings = new ArrayList();
    public static WeakHashMap<Node, List<String>> externedAliases = new WeakHashMap();
    private ArrayList<String> externAliases = new ArrayList();
    public static WeakHashMap<Node, List<String>> providedsMap = new WeakHashMap();
    private ArrayList<String> provideds = new ArrayList();

    ProcessClosurePrimitivesWithModuleSupport(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CheckLevel requiresLevel, boolean preserveGoogProvidesAndRequires) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.moduleGraph = compiler.getModuleGraph();
        this.requiresLevel = requiresLevel;
        this.preserveGoogProvidesAndRequires = preserveGoogProvidesAndRequires;
        this.providedNames.put(GOOG, new ProvidedName(GOOG, null, null, false));
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    public void process(Node externs, Node root) {
        GlobalNamespace externNamespace = new GlobalNamespace(this.compiler, externs);
        List externNames = externNamespace.getNameForest();
        for (GlobalNamespace.Name en : externNames) {
            this.addExternNameAndDescendants(en, this.externStrings);
        }
        externedAliases.put(externs, this.externAliases);
        providedsMap.put(externs, this.provideds);
        NodeTraversal.traverseRoots((AbstractCompiler)this.compiler, (NodeTraversal.Callback)this, (Node)externs, (Node)root);
        for (Node n : this.defineCalls) {
            this.replaceGoogDefines(n);
        }
        for (ProvidedName pn : this.providedNames.values()) {
            pn.replace();
        }
        if (this.requiresLevel.isOn()) {
            for (UnrecognizedRequire r : this.unrecognizedRequires) {
                this.checkForLateOrMissingProvide(r);
            }
        }
        for (Node closureRequire : this.requiresToBeRemoved) {
            this.compiler.reportChangeToEnclosingScope(closureRequire);
            closureRequire.detach();
        }
        for (Node liveNode : this.maybeTemporarilyLiveNodes) {
            this.compiler.reportChangeToEnclosingScope(liveNode);
        }
    }

    private void checkForLateOrMissingProvide(UnrecognizedRequire r) {
        DiagnosticType error;
        ProvidedName expectedName = this.providedNames.get(r.namespace);
        if (expectedName != null && expectedName.firstNode != null) {
            if (r.isRequireType) {
                return;
            }
            error = LATE_PROVIDE_ERROR;
        } else {
            error = MISSING_PROVIDE_ERROR;
        }
        this.compiler.report(JSError.make((Node)r.requireNode, (CheckLevel)this.requiresLevel, (DiagnosticType)error, (String[])new String[]{r.namespace}));
    }

    private Node getAnyValueOfType(JSDocInfo jsdoc) {
        Preconditions.checkArgument(jsdoc.hasType());
        Node typeAst = jsdoc.getType().getRoot();
        if (typeAst.getToken() == Token.BANG) {
            typeAst = typeAst.getLastChild();
        }
        Preconditions.checkState(typeAst.isString(), typeAst);
        String astType = typeAst.getString();
        if (astType.contentEquals("boolean")) {
            return IR.falseNode();
        }
        if (astType.contentEquals("string")) {
            return IR.string((String)"");
        }
        if (astType.contentEquals("number")) {
            return IR.number((double)0.0);
        }
        throw new RuntimeException(typeAst.getString());
    }

    private void replaceGoogDefines(Node n) {
        Node parent = n.getParent();
        Preconditions.checkState(parent.isExprResult());
        String name = n.getSecondChild().getString();
        JSDocInfo jsdoc = n.getJSDocInfo();
        Node value = n.isFromExterns() ? this.getAnyValueOfType(jsdoc).srcref(n) : n.getChildAtIndex(2).detach();
        Node replacement = NodeUtil.newQNameDeclaration((AbstractCompiler)this.compiler, (String)name, (Node)value, (JSDocInfo)jsdoc);
        replacement.useSourceInfoIfMissingFromForTree(parent);
        parent.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(replacement);
    }

    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process((CompilerPass)this);
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case CALL: {
                Node left = n.getFirstChild();
                if (!left.isGetProp()) break;
                Node name = left.getFirstChild();
                if (name.isName() && GOOG.equals(name.getString())) {
                    String methodName = name.getNext().getString();
                    if (methodName.contentEquals("base")) {
                        this.processBaseClassCall(t, n);
                        break;
                    }
                    if (methodName.contentEquals("define")) {
                        if (!this.validateUnaliasablePrimitiveCall(t, n, methodName)) break;
                        this.processDefineCall(t, n, parent);
                        break;
                    }
                    if (methodName.contentEquals("require") || methodName.contentEquals("requireType")) {
                        if (!this.validateAliasiablePrimitiveCall(t, n, methodName)) break;
                        this.processRequireCall(t, n, parent);
                        break;
                    }
                    if (methodName.contentEquals("provide")) {
                        if (!this.validateUnaliasablePrimitiveCall(t, n, methodName)) break;
                        this.processProvideCall(t, n, parent);
                        break;
                    }
                    if (methodName.contentEquals("inherits")) {
                        this.processInheritsCall(n);
                        break;
                    }
                    if (methodName.contentEquals("exportSymbol")) {
                        Node arg = left.getNext();
                        if (!arg.isString()) break;
                        String argString = arg.getString();
                        int dot = argString.indexOf(46);
                        if (dot == -1) {
                            this.exportedVariables.add(argString);
                            break;
                        }
                        this.exportedVariables.add(argString.substring(0, dot));
                        break;
                    }
                    if (methodName.contentEquals("forwardDeclare")) {
                        if (!this.validateAliasiablePrimitiveCall(t, n, methodName)) break;
                        this.processForwardDeclare(t, n, parent);
                        break;
                    }
                    if (methodName.contentEquals("addDependency")) {
                        if (!this.validateUnaliasablePrimitiveCall(t, n, methodName)) break;
                        this.processAddDependency(n, parent);
                        break;
                    }
                    if (!methodName.contentEquals("setCssNameMapping")) break;
                    this.processSetCssNameMapping(t, n, parent);
                    break;
                }
                if (!left.getLastChild().getString().equals("base")) break;
                this.maybeProcessClassBaseCall(t, n);
                break;
            }
            case ASSIGN: 
            case NAME: {
                if (n.isName() && n.getString().equals("CLOSURE_DEFINES")) {
                    this.handleClosureDefinesValues(t, n);
                    break;
                }
                this.handleCandidateProvideDefinition(t, n, parent);
                break;
            }
            case EXPR_RESULT: {
                this.handleStubDefinition(t, n);
                break;
            }
            case CLASS: {
                String name;
                ProvidedName pn;
                if (!t.inGlobalHoistScope() || NodeUtil.isClassExpression((Node)n) || (pn = this.providedNames.get(name = n.getFirstChild().getString())) == null) break;
                this.compiler.report(t.makeError(n, CLASS_NAMESPACE_ERROR, new String[]{name}));
                break;
            }
            case FUNCTION: {
                String name;
                ProvidedName pn;
                if (!t.inGlobalHoistScope() || !NodeUtil.isFunctionDeclaration((Node)n) || (pn = this.providedNames.get(name = n.getFirstChild().getString())) == null) break;
                this.compiler.report(t.makeError(n, FUNCTION_NAMESPACE_ERROR, new String[]{name}));
                break;
            }
            case GETPROP: {
                if (!n.getFirstChild().isName() || parent.isCall() || parent.isAssign() || !n.matchesQualifiedName("goog.base") || n.getSourceFileName().endsWith("goog.js")) break;
                this.reportBadGoogBaseUse(t, n, "May only be called directly.");
                break;
            }
        }
    }

    private boolean validateUnaliasablePrimitiveCall(NodeTraversal t, Node n, String methodName) {
        return this.validatePrimitiveCallWithMessage(t, n, methodName, CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR);
    }

    private boolean validateAliasiablePrimitiveCall(NodeTraversal t, Node n, String methodName) {
        return this.validatePrimitiveCallWithMessage(t, n, methodName, CLOSURE_CALL_CANNOT_BE_ALIASED_OUTSIDE_MODULE_ERROR);
    }

    private boolean validatePrimitiveCallWithMessage(NodeTraversal t, Node n, String methodName, DiagnosticType invalidAliasingError) {
        if (this.compiler.getOptions().shouldPreserveGoogModule()) {
            return true;
        }
        if (!t.inGlobalHoistScope()) {
            this.compiler.report(t.makeError(n, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]));
            return false;
        }
        if (!n.getParent().isExprResult()) {
            this.compiler.report(t.makeError(n, invalidAliasingError, new String[]{"goog." + methodName}));
            return false;
        }
        return true;
    }

    private void handleClosureDefinesValues(NodeTraversal t, Node n) {
        if (NodeUtil.isNameDeclaration((Node)n.getParent()) && n.hasOneChild() && n.getFirstChild().isObjectLit()) {
            HashMap<String, Node> builder = new HashMap<String, Node>();
            builder.putAll(this.compiler.getDefaultDefineValues());
            for (Node c : n.getFirstChild().children()) {
                if (c.isStringKey() && c.getFirstChild() != null && ProcessClosurePrimitivesWithModuleSupport.isValidDefineValue(c.getFirstChild())) {
                    builder.put(c.getString(), c.getFirstChild().cloneTree());
                    continue;
                }
                this.reportBadClosureCommonDefinesDefinition(t, c);
            }
            this.compiler.setDefaultDefineValues(ImmutableMap.copyOf(builder));
        }
    }

    static boolean isValidDefineValue(Node val) {
        switch (val.getToken()) {
            case STRING: 
            case NUMBER: 
            case TRUE: 
            case FALSE: {
                return true;
            }
            case NEG: {
                return val.getFirstChild().isNumber();
            }
        }
        return false;
    }

    private void processRequireCall(NodeTraversal t, Node n, Node parent) {
        Node left = n.getFirstChild();
        Node arg = left.getNext();
        String method = left.getFirstChild().getNext().getString();
        if (this.verifyLastArgumentIsString(t, left, arg)) {
            String ns = arg.getString();
            ProvidedName provided = this.providedNames.get(ns);
            if (provided == null || !provided.isExplicitlyProvided()) {
                this.unrecognizedRequires.add(new UnrecognizedRequire(n, ns, method.equals("requireType")));
            } else {
                JSModule providedModule = provided.explicitModule;
                if (!provided.isFromExterns()) {
                    Preconditions.checkNotNull(providedModule, n);
                    JSModule module = t.getModule();
                    if (module != providedModule && !this.moduleGraph.dependsOn(module, providedModule) && !method.equals("requireType")) {
                        this.compiler.report(t.makeError(n, XMODULE_REQUIRE_ERROR, new String[]{ns, providedModule.getName(), module.getName()}));
                    }
                }
            }
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(arg);
            if (!this.preserveGoogProvidesAndRequires && (provided != null || this.requiresLevel.isOn())) {
                this.requiresToBeRemoved.add(parent);
            }
        }
    }

    private void processProvideCall(NodeTraversal t, Node n, Node parent) {
        Preconditions.checkState(n.isCall());
        Node left = n.getFirstChild();
        Node arg = left.getNext();
        if (this.verifyProvide(t, left, arg)) {
            String ns = arg.getString();
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(arg);
            if (this.providedNames.containsKey(ns)) {
                ProvidedName previouslyProvided = this.providedNames.get(ns);
                if (!previouslyProvided.isExplicitlyProvided()) {
                    previouslyProvided.addProvide(parent, t.getModule(), true);
                } else {
                    String explicitSourceName = previouslyProvided.explicitNode.getSourceFileName();
                    this.compiler.report(t.makeError(n, DUPLICATE_NAMESPACE_ERROR, new String[]{ns, explicitSourceName}));
                }
            } else {
                this.registerAnyProvidedPrefixes(ns, parent, t.getModule());
                this.providedNames.put(ns, new ProvidedName(ns, parent, t.getModule(), true));
            }
        }
    }

    private void processDefineCall(NodeTraversal t, Node n, Node parent) {
        Node args;
        Node left = n.getFirstChild();
        if (this.verifyDefine(t, parent, left, args = left.getNext())) {
            Node nameNode = args;
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(nameNode);
            this.defineCalls.add(n);
        }
    }

    private void handleStubDefinition(NodeTraversal t, Node n) {
        boolean hasStubDefinition;
        if (!t.inGlobalHoistScope()) {
            return;
        }
        JSDocInfo info = n.getFirstChild().getJSDocInfo();
        boolean bl = hasStubDefinition = info != null && (n.isFromExterns() || info.hasTypedefType());
        if (hasStubDefinition && n.getFirstChild().isQualifiedName()) {
            String name = n.getFirstChild().getQualifiedName();
            ProvidedName pn = this.providedNames.get(name);
            if (pn != null) {
                n.putBooleanProp(Node.WAS_PREVIOUSLY_PROVIDED, true);
                pn.addDefinition(n, t.getModule());
            } else if (n.getBooleanProp(Node.WAS_PREVIOUSLY_PROVIDED)) {
                ProvidedName provided = new ProvidedName(name, n, t.getModule(), true);
                this.providedNames.put(name, provided);
            }
        }
    }

    private void handleCandidateProvideDefinition(NodeTraversal t, Node n, Node parent) {
        if (t.inGlobalHoistScope()) {
            String name = null;
            if (n.isName() && NodeUtil.isNameDeclaration((Node)parent)) {
                name = n.getString();
            } else if (n.isAssign() && parent.isExprResult()) {
                name = n.getFirstChild().getQualifiedName();
            }
            if (name != null) {
                if (parent.getBooleanProp(Node.IS_NAMESPACE)) {
                    this.processProvideFromPreviousPass(t, name, parent);
                } else {
                    ProvidedName pn = this.providedNames.get(name);
                    if (pn != null) {
                        pn.addDefinition(parent, t.getModule());
                    }
                }
            }
        }
    }

    private void processBaseClassCall(NodeTraversal t, Node n) {
        t.report(n, USE_OF_GOOG_BASE, new String[0]);
        if (this.baseUsedInClass(n)) {
            this.reportBadGoogBaseUse(t, n, "goog.base in ES6 class is not allowed. Use super instead.");
            return;
        }
        Node callee = n.getFirstChild();
        Node thisArg = callee.getNext();
        if (thisArg == null || !thisArg.isThis()) {
            this.reportBadGoogBaseUse(t, n, "First argument must be 'this'.");
            return;
        }
        Node enclosingFnNameNode = ProcessClosurePrimitivesWithModuleSupport.getEnclosingDeclNameNode(n);
        if (enclosingFnNameNode == null) {
            this.reportBadGoogBaseUse(t, n, "Could not find enclosing method.");
            return;
        }
        String enclosingQname = enclosingFnNameNode.getQualifiedName();
        if (!enclosingQname.contains(".prototype.")) {
            Node callNode;
            Node enclosingParent = enclosingFnNameNode.getParent();
            Node maybeInheritsExpr = (enclosingParent.isAssign() ? enclosingParent.getParent() : enclosingParent).getNext();
            Node baseClassNode = null;
            if (maybeInheritsExpr != null && maybeInheritsExpr.isExprResult() && maybeInheritsExpr.getFirstChild().isCall() && (callNode = maybeInheritsExpr.getFirstChild()).getFirstChild().matchesQualifiedName("goog.inherits") && callNode.getLastChild().isQualifiedName()) {
                baseClassNode = callNode.getLastChild();
            }
            if (baseClassNode == null) {
                this.reportBadGoogBaseUse(t, n, "Could not find goog.inherits for base class");
                return;
            }
            Node newCallee = NodeUtil.newQName((AbstractCompiler)this.compiler, (String)(baseClassNode.getQualifiedName() + ".call"), (Node)callee, (String)"goog.base");
            n.replaceChild(callee, newCallee);
            this.compiler.reportChangeToEnclosingScope(newCallee);
        } else {
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString()) {
                this.reportBadGoogBaseUse(t, n, "Second argument must name a method.");
                return;
            }
            String methodName = methodNameNode.getString();
            String ending = ".prototype." + methodName;
            if (enclosingQname == null || !enclosingQname.endsWith(ending)) {
                this.reportBadGoogBaseUse(t, n, "Enclosing method does not match " + methodName);
                return;
            }
            Node className = enclosingFnNameNode.getFirstFirstChild();
            n.replaceChild(callee, NodeUtil.newQName((AbstractCompiler)this.compiler, (String)(className.getQualifiedName() + ".superClass_." + methodName + ".call"), (Node)callee, (String)"goog.base"));
            n.removeChild(methodNameNode);
            this.compiler.reportChangeToEnclosingScope(n);
        }
    }

    private void maybeProcessClassBaseCall(NodeTraversal t, Node n) {
        Node callTarget = n.getFirstChild();
        Node baseContainerNode = callTarget.getFirstChild();
        if (!baseContainerNode.isUnscopedQualifiedName()) {
            return;
        }
        String baseContainer = callTarget.getFirstChild().getQualifiedName();
        Node enclosingFnNameNode = ProcessClosurePrimitivesWithModuleSupport.getEnclosingDeclNameNode(n);
        if (enclosingFnNameNode == null || !enclosingFnNameNode.isUnscopedQualifiedName()) {
            Node clazz;
            if (this.knownClosureSubclasses.contains(baseContainer)) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Could not find enclosing method.");
            } else if (this.baseUsedInClass(n) && ((clazz = NodeUtil.getEnclosingClass((Node)n)).getFirstChild().isName() && clazz.getFirstChild().getString().equals(baseContainer) || clazz.getSecondChild().isName() && clazz.getSecondChild().getString().equals(baseContainer))) {
                this.reportBadBaseMethodUse(t, n, clazz.getFirstChild().getString(), "base method is not allowed in ES6 class. Use super instead.");
            }
            return;
        }
        if (this.baseUsedInClass(n)) {
            this.reportBadGoogBaseUse(t, n, "goog.base in ES6 class is not allowed. Use super instead.");
            return;
        }
        String enclosingQname = enclosingFnNameNode.getQualifiedName();
        if (!enclosingQname.contains(".prototype.")) {
            Node callNode;
            Node maybeInheritsExpr;
            if (!enclosingQname.equals(baseContainer)) {
                if (this.knownClosureSubclasses.contains(baseContainer)) {
                    this.reportBadBaseMethodUse(t, n, baseContainer, "Must be used within " + baseContainer + " methods");
                }
                return;
            }
            for (maybeInheritsExpr = ((enclosingParent = enclosingFnNameNode.getParent()).isAssign() ? enclosingParent.getParent() : enclosingParent).getNext(); maybeInheritsExpr != null && maybeInheritsExpr.isEmpty(); maybeInheritsExpr = maybeInheritsExpr.getNext()) {
            }
            Node baseClassNode = null;
            if (maybeInheritsExpr != null && maybeInheritsExpr.isExprResult() && maybeInheritsExpr.getFirstChild().isCall() && (callNode = maybeInheritsExpr.getFirstChild()).getFirstChild().matchesQualifiedName("goog.inherits") && callNode.getLastChild().isQualifiedName()) {
                baseClassNode = callNode.getLastChild();
            }
            if (baseClassNode == null) {
                return;
            }
            Node callee = n.getFirstChild();
            Node thisArg = callee.getNext();
            if (thisArg == null || !thisArg.isThis()) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "First argument must be 'this'.");
                return;
            }
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString() || !methodNameNode.getString().equals("constructor")) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Second argument must be 'constructor'.");
                return;
            }
            n.replaceChild(callee, NodeUtil.newQName((AbstractCompiler)this.compiler, (String)(baseClassNode.getQualifiedName() + ".call"), (Node)callee, (String)(enclosingQname + ".base")));
            n.removeChild(methodNameNode);
            this.compiler.reportChangeToEnclosingScope(n);
        } else {
            boolean misuseOfBase;
            if (!this.knownClosureSubclasses.contains(baseContainer)) {
                return;
            }
            boolean bl = misuseOfBase = !enclosingFnNameNode.getFirstFirstChild().matchesQualifiedName(baseContainer);
            if (misuseOfBase) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Must be used within " + baseContainer + " methods");
                return;
            }
            Node callee = n.getFirstChild();
            Node thisArg = callee.getNext();
            if (thisArg == null || !thisArg.isThis()) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "First argument must be 'this'.");
                return;
            }
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString()) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Second argument must name a method.");
                return;
            }
            String methodName = methodNameNode.getString();
            String ending = ".prototype." + methodName;
            if (enclosingQname == null || !enclosingQname.endsWith(ending)) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Enclosing method does not match " + methodName);
                return;
            }
            Node className = enclosingFnNameNode.getFirstFirstChild();
            n.replaceChild(callee, NodeUtil.newQName((AbstractCompiler)this.compiler, (String)(className.getQualifiedName() + ".superClass_." + methodName + ".call"), (Node)callee, (String)(enclosingQname + ".base")));
            n.removeChild(methodNameNode);
            this.compiler.reportChangeToEnclosingScope(n);
        }
    }

    private void processInheritsCall(Node n) {
        if (n.getChildCount() == 3) {
            Node subClass = n.getSecondChild();
            Node superClass = subClass.getNext();
            if (subClass.isUnscopedQualifiedName() && superClass.isUnscopedQualifiedName()) {
                this.knownClosureSubclasses.add(subClass.getQualifiedName());
            }
        }
    }

    private static Node getEnclosingDeclNameNode(Node n) {
        Node fn = NodeUtil.getEnclosingFunction((Node)n);
        return fn == null ? null : NodeUtil.getNameNode((Node)fn);
    }

    private boolean baseUsedInClass(Node n) {
        for (Node curr = n; curr != null; curr = curr.getParent()) {
            if (!curr.isClassMembers()) continue;
            return true;
        }
        return false;
    }

    private void reportBadGoogBaseUse(NodeTraversal t, Node n, String extraMessage) {
        this.compiler.report(t.makeError(n, GOOG_BASE_CLASS_ERROR, new String[]{extraMessage}));
    }

    private void reportBadBaseMethodUse(NodeTraversal t, Node n, String className, String extraMessage) {
        this.compiler.report(t.makeError(n, BASE_CLASS_ERROR, new String[]{className, extraMessage}));
    }

    private void reportBadClosureCommonDefinesDefinition(NodeTraversal t, Node n) {
        this.compiler.report(t.makeError(n, CLOSURE_DEFINES_ERROR, new String[0]));
    }

    private void processProvideFromPreviousPass(NodeTraversal t, String name, Node parent) {
        if (!this.providedNames.containsKey(name)) {
            Node expr = new Node(Token.EXPR_RESULT);
            expr.useSourceInfoIfMissingFromForTree(parent);
            parent.getParent().addChildBefore(expr, parent);
            this.maybeTemporarilyLiveNodes.add(expr);
            JSModule module = t.getModule();
            this.registerAnyProvidedPrefixes(name, expr, module);
            if (!expr.hasChildren()) {
                expr.addChildToBack(NodeUtil.newUndefinedNode((Node)parent));
            }
            ProvidedName provided = new ProvidedName(name, expr, module, true);
            this.providedNames.put(name, provided);
            provided.addDefinition(parent, module);
        } else if (ProcessClosurePrimitivesWithModuleSupport.isNamespacePlaceholder(parent)) {
            this.compiler.reportChangeToEnclosingScope(parent);
            parent.detach();
        }
    }

    private void processSetCssNameMapping(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifySetCssNameMapping(t, left, arg = left.getNext())) {
            ArrayList<String> errors;
            CssRenamingMap.Style style;
            final HashMap<String, String> cssNames = new HashMap<String, String>();
            for (Node key = arg.getFirstChild(); key != null; key = key.getNext()) {
                Node value = key.getFirstChild();
                if (!key.isStringKey() || value == null || !value.isString()) {
                    this.compiler.report(t.makeError(n, NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR, new String[0]));
                    return;
                }
                cssNames.put(key.getString(), value.getString());
            }
            String styleStr = "BY_PART";
            if (arg.getNext() != null) {
                styleStr = arg.getNext().getString();
            }
            try {
                style = CssRenamingMap.Style.valueOf((String)styleStr);
            }
            catch (IllegalArgumentException e) {
                this.compiler.report(t.makeError(n, INVALID_STYLE_ERROR, new String[]{styleStr}));
                return;
            }
            if (style == CssRenamingMap.Style.BY_PART) {
                errors = new ArrayList<String>();
                for (String key : cssNames.keySet()) {
                    if (!key.contains("-")) continue;
                    errors.add(key);
                }
                if (!errors.isEmpty()) {
                    this.compiler.report(t.makeError(n, INVALID_CSS_RENAMING_MAP, new String[]{((Object)errors).toString()}));
                }
            } else if (style == CssRenamingMap.Style.BY_WHOLE) {
                errors = new ArrayList();
                for (Map.Entry b : cssNames.entrySet()) {
                    if (((String)b.getKey()).length() > 10) continue;
                    for (Map.Entry a : cssNames.entrySet()) {
                        String combined = (String)cssNames.get((String)a.getKey() + "-" + (String)b.getKey());
                        if (combined == null || combined.equals((String)a.getValue() + "-" + (String)b.getValue())) continue;
                        errors.add("map(" + (String)a.getKey() + "-" + (String)b.getKey() + ") != map(" + (String)a.getKey() + ")-map(" + (String)b.getKey() + ")");
                    }
                }
                if (!errors.isEmpty()) {
                    this.compiler.report(t.makeError(n, INVALID_CSS_RENAMING_MAP, new String[]{((Object)errors).toString()}));
                }
            }
            CssRenamingMap cssRenamingMap = new CssRenamingMap(){

                public String get(String value) {
                    if (cssNames.containsKey(value)) {
                        return (String)cssNames.get(value);
                    }
                    return value;
                }

                public CssRenamingMap.Style getStyle() {
                    return style;
                }
            };
            this.compiler.setCssRenamingMap(cssRenamingMap);
            this.compiler.reportChangeToEnclosingScope(parent);
            parent.detach();
        }
    }

    private boolean verifyProvide(NodeTraversal t, Node methodName, Node arg) {
        if (!this.verifyLastArgumentIsString(t, methodName, arg)) {
            return false;
        }
        if (!NodeUtil.isValidQualifiedName((FeatureSet)this.compiler.getOptions().getLanguageIn().toFeatureSet(), (String)arg.getString())) {
            this.compiler.report(t.makeError(arg, INVALID_PROVIDE_ERROR, new String[]{arg.getString(), this.compiler.getOptions().getLanguageIn().toString()}));
            return false;
        }
        return true;
    }

    private boolean verifyDefine(NodeTraversal t, Node expr, Node methodName, Node args) {
        Node arg = args;
        if (!this.verifyNotNull(t, methodName, arg) || !this.verifyOfType(t, methodName, arg, Token.STRING)) {
            return false;
        }
        arg = arg.getNext();
        if (!(args.isFromExterns() || this.verifyNotNull(t, methodName, arg) && this.verifyIsLast(t, methodName, arg))) {
            return false;
        }
        String name = args.getString();
        if (!NodeUtil.isValidQualifiedName((FeatureSet)this.compiler.getOptions().getLanguageIn().toFeatureSet(), (String)name)) {
            this.compiler.report(t.makeError(args, INVALID_DEFINE_NAME_ERROR, new String[]{name}));
            return false;
        }
        JSDocInfo info = expr.getFirstChild().getJSDocInfo();
        if (info == null || !info.isDefine()) {
            this.compiler.report(t.makeError(expr, MISSING_DEFINE_ANNOTATION, new String[0]));
            return false;
        }
        return true;
    }

    private void processAddDependency(Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        List typeDecls = convention.identifyTypeDeclarationCall(n);
        if (typeDecls != null) {
            for (String typeDecl : typeDecls) {
                this.compiler.forwardDeclareType(typeDecl);
            }
        }
        Node emptyNode = IR.number((double)0.0);
        parent.replaceChild(n, emptyNode);
        this.compiler.reportChangeToEnclosingScope(emptyNode);
    }

    private void processForwardDeclare(NodeTraversal t, Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        String typeDeclaration = null;
        try {
            typeDeclaration = (String)Iterables.getOnlyElement(convention.identifyTypeDeclarationCall(n));
        }
        catch (Exception e) {
            this.compiler.report(t.makeError(n, INVALID_FORWARD_DECLARE, new String[]{"A single type could not identified for the goog.forwardDeclare statement"}));
        }
        if (typeDeclaration != null) {
            this.compiler.forwardDeclareType(typeDeclaration);
            Node toRemove = parent.isExprResult() ? parent : parent.getParent();
            NodeUtil.deleteNode((Node)toRemove, (AbstractCompiler)this.compiler);
        }
    }

    private boolean verifyLastArgumentIsString(NodeTraversal t, Node methodName, Node arg) {
        return this.verifyNotNull(t, methodName, arg) && this.verifyOfType(t, methodName, arg, Token.STRING) && this.verifyIsLast(t, methodName, arg);
    }

    private boolean verifyNotNull(NodeTraversal t, Node methodName, Node arg) {
        if (arg == null) {
            this.compiler.report(t.makeError(methodName, NULL_ARGUMENT_ERROR, new String[]{methodName.getQualifiedName()}));
            return false;
        }
        return true;
    }

    private boolean verifyOfType(NodeTraversal t, Node methodName, Node arg, Token desiredType) {
        if (arg.getToken() != desiredType) {
            this.compiler.report(t.makeError(methodName, INVALID_ARGUMENT_ERROR, new String[]{methodName.getQualifiedName()}));
            return false;
        }
        return true;
    }

    private boolean verifyIsLast(NodeTraversal t, Node methodName, Node arg) {
        if (arg.getNext() != null) {
            this.compiler.report(t.makeError(methodName, TOO_MANY_ARGUMENTS_ERROR, new String[]{methodName.getQualifiedName()}));
            return false;
        }
        return true;
    }

    private boolean verifySetCssNameMapping(NodeTraversal t, Node methodName, Node firstArg) {
        DiagnosticType diagnostic = null;
        if (firstArg == null) {
            diagnostic = NULL_ARGUMENT_ERROR;
        } else if (!firstArg.isObjectLit()) {
            diagnostic = EXPECTED_OBJECTLIT_ERROR;
        } else if (firstArg.getNext() != null) {
            Node secondArg = firstArg.getNext();
            if (!secondArg.isString()) {
                diagnostic = EXPECTED_STRING_ERROR;
            } else if (secondArg.getNext() != null) {
                diagnostic = TOO_MANY_ARGUMENTS_ERROR;
            }
        }
        if (diagnostic != null) {
            this.compiler.report(t.makeError(methodName, diagnostic, new String[]{methodName.getQualifiedName()}));
            return false;
        }
        return true;
    }

    private void addExternNameAndDescendants(GlobalNamespace.Name en, ArrayList<String> externStrings) {
        externStrings.add(en.getName());
        if (en.props == null || en.isCollapsingExplicitlyDenied()) {
            return;
        }
        for (GlobalNamespace.Name p : en.props) {
            this.addExternNameAndDescendants(p, externStrings);
        }
    }

    private void registerAnyProvidedPrefixes(String ns, Node node, JSModule module) {
        int pos = ns.indexOf(46);
        while (pos != -1) {
            String prefixNs = ns.substring(0, pos);
            pos = ns.indexOf(46, pos + 1);
            if (this.providedNames.containsKey(prefixNs)) {
                this.providedNames.get(prefixNs).addProvide(node, module, false);
                continue;
            }
            this.providedNames.put(prefixNs, new ProvidedName(prefixNs, node, module, false));
            if (this.externStrings.contains(prefixNs) && !this.externAliases.contains(prefixNs)) {
                this.externAliases.add(prefixNs);
            }
            if (this.provideds.contains(prefixNs)) continue;
            this.provideds.add(prefixNs);
        }
    }

    private JSDocInfo createUnknownTypeJsDocInfo() {
        JSDocInfoBuilder castToUnknownBuilder = new JSDocInfoBuilder(true);
        castToUnknownBuilder.recordType(new JSTypeExpression(JsDocInfoParser.parseTypeString((String)"?"), "<ProcessClosurePrimitives.java>"));
        return castToUnknownBuilder.build();
    }

    private static boolean isNamespacePlaceholder(Node n) {
        if (!n.getBooleanProp(Node.IS_NAMESPACE)) {
            return false;
        }
        Node value = null;
        if (n.isExprResult()) {
            Node assign = n.getFirstChild();
            value = assign.getLastChild();
        } else if (n.isVar()) {
            Node name = n.getFirstChild();
            value = name.getFirstChild();
        }
        if (value == null) {
            return false;
        }
        if (value.isCast()) {
            value = value.getOnlyChild();
        }
        return value.isObjectLit() && !value.hasChildren();
    }

    private void maybeAddStringNodeToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        String name = n.getString();
        Node syntheticRef = NodeUtil.newQName((AbstractCompiler)this.compiler, (String)name, (Node)n, (String)name);
        boolean forQuote = true;
        boolean forDot = true;
        Node current = null;
        current = syntheticRef;
        while (current.isGetProp()) {
            int fullLen = current.getQualifiedName().length();
            int namespaceLen = current.getFirstChild().getQualifiedName().length();
            current.setSourceEncodedPosition(n.getSourcePosition() + 1);
            current.setLength(fullLen);
            current.getLastChild().setSourceEncodedPosition(n.getSourcePosition() + namespaceLen + 1 + 1);
            current.getLastChild().setLength(current.getLastChild().getString().length());
            current = current.getFirstChild();
        }
        current.setSourceEncodedPosition(n.getSourcePosition() + 1);
        current.setLength(current.getString().length());
        this.maybeAddToSymbolTable(syntheticRef);
    }

    private void maybeAddToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(n);
        }
    }

    private static class UnrecognizedRequire {
        final Node requireNode;
        final String namespace;
        final boolean isRequireType;

        UnrecognizedRequire(Node requireNode, String namespace, boolean isRequireType) {
            this.requireNode = requireNode;
            this.namespace = namespace;
            this.isRequireType = isRequireType;
        }
    }

    private class ProvidedName {
        private final String namespace;
        private final Node firstNode;
        private final JSModule firstModule;
        private Node explicitNode = null;
        private JSModule explicitModule = null;
        private boolean hasAChildNamespace = false;
        private Node candidateDefinition = null;
        private JSModule minimumModule = null;
        private Node replacementNode = null;

        ProvidedName(String namespace, Node node, JSModule module, boolean explicit) {
            Preconditions.checkArgument(node == null || node.isExprResult());
            this.namespace = namespace;
            this.firstNode = node;
            this.firstModule = module;
            this.addProvide(node, module, explicit);
        }

        void addProvide(Node node, JSModule module, boolean explicit) {
            if (explicit) {
                Preconditions.checkState(this.explicitNode == null);
                Preconditions.checkArgument(node.isExprResult());
                this.explicitNode = node;
                this.explicitModule = module;
            } else {
                this.hasAChildNamespace = true;
            }
            this.updateMinimumModule(module);
        }

        boolean isExplicitlyProvided() {
            return this.explicitNode != null;
        }

        boolean isFromExterns() {
            return this.explicitNode.isFromExterns();
        }

        void addDefinition(Node node, JSModule module) {
            Preconditions.checkArgument(node.isExprResult() || node.isFunction() || NodeUtil.isNameDeclaration((Node)node));
            Preconditions.checkArgument(this.explicitNode != node);
            if (this.candidateDefinition == null || !node.isExprResult()) {
                this.candidateDefinition = node;
                this.updateMinimumModule(module);
            }
        }

        private void updateMinimumModule(JSModule newModule) {
            if (this.minimumModule == null) {
                this.minimumModule = newModule;
            } else if (ProcessClosurePrimitivesWithModuleSupport.this.moduleGraph.getModuleCount() > 1) {
                this.minimumModule = ProcessClosurePrimitivesWithModuleSupport.this.moduleGraph.getDeepestCommonDependencyInclusive(this.minimumModule, newModule);
            } else {
                Preconditions.checkState(newModule == this.minimumModule, "Missing module graph");
            }
        }

        void replace() {
            if (this.firstNode == null) {
                this.replacementNode = this.candidateDefinition;
                return;
            }
            if (this.candidateDefinition != null && this.explicitNode != null) {
                JSTypeExpression expr;
                JSDocInfo info = this.candidateDefinition.isExprResult() ? this.candidateDefinition.getFirstChild().getJSDocInfo() : this.candidateDefinition.getJSDocInfo();
                if (info != null && (expr = info.getType()) != null) {
                    Node n = expr.getRoot();
                    if (n.getToken() == Token.BANG) {
                        n = n.getFirstChild();
                    }
                    if (n.isString() && !n.hasChildren() && n.getString().equals("Object")) {
                        ProcessClosurePrimitivesWithModuleSupport.this.compiler.report(JSError.make((Node)this.candidateDefinition, (DiagnosticType)WEAK_NAMESPACE_TYPE, (String[])new String[0]));
                    }
                }
                this.replacementNode = this.candidateDefinition;
                if (this.candidateDefinition.isExprResult()) {
                    Node exprNode = this.candidateDefinition.getOnlyChild();
                    if (exprNode.isAssign()) {
                        this.candidateDefinition.putBooleanProp(Node.IS_NAMESPACE, true);
                        Node nameNode = exprNode.getFirstChild();
                        if (nameNode.isName()) {
                            Node valueNode = nameNode.getNext();
                            exprNode.removeChild(nameNode);
                            exprNode.removeChild(valueNode);
                            nameNode.addChildToFront(valueNode);
                            Node varNode = IR.var((Node)nameNode);
                            varNode.useSourceInfoFrom(this.candidateDefinition);
                            this.candidateDefinition.replaceWith(varNode);
                            varNode.setJSDocInfo(exprNode.getJSDocInfo());
                            ProcessClosurePrimitivesWithModuleSupport.this.compiler.reportChangeToEnclosingScope(varNode);
                            this.replacementNode = varNode;
                        }
                    } else {
                        Preconditions.checkState(exprNode.isQualifiedName(), exprNode);
                        if (this.hasAChildNamespace) {
                            this.replaceWith(this.createDeclarationNode(IR.cast((Node)IR.objectlit((Node[])new Node[0]), (JSDocInfo)ProcessClosurePrimitivesWithModuleSupport.this.createUnknownTypeJsDocInfo())));
                        }
                    }
                }
            } else {
                this.replaceWith(this.createDeclarationNode(IR.objectlit((Node[])new Node[0])));
            }
            if (this.explicitNode != null) {
                if (ProcessClosurePrimitivesWithModuleSupport.this.preserveGoogProvidesAndRequires && this.explicitNode.hasChildren()) {
                    return;
                }
                if (!ProcessClosurePrimitivesWithModuleSupport.this.maybeTemporarilyLiveNodes.remove(this.explicitNode)) {
                    ProcessClosurePrimitivesWithModuleSupport.this.compiler.reportChangeToEnclosingScope(this.explicitNode);
                }
                this.explicitNode.detach();
            }
        }

        private void replaceWith(Node replacement) {
            this.replacementNode = replacement;
            if (this.firstModule == this.minimumModule) {
                this.firstNode.getParent().addChildBefore(this.replacementNode, this.firstNode);
            } else {
                int indexOfDot = this.namespace.lastIndexOf(46);
                if (indexOfDot == -1) {
                    ProcessClosurePrimitivesWithModuleSupport.this.compiler.getNodeForCodeInsertion(this.minimumModule).addChildToBack(this.replacementNode);
                } else {
                    ProvidedName parentName = (ProvidedName)ProcessClosurePrimitivesWithModuleSupport.this.providedNames.get(this.namespace.substring(0, indexOfDot));
                    Preconditions.checkNotNull(parentName);
                    Preconditions.checkNotNull(parentName.replacementNode);
                    parentName.replacementNode.getParent().addChildAfter(this.replacementNode, parentName.replacementNode);
                }
            }
            ProcessClosurePrimitivesWithModuleSupport.this.compiler.reportChangeToEnclosingScope(this.replacementNode);
        }

        private Node createDeclarationNode(Node value) {
            if (this.namespace.indexOf(46) == -1) {
                return this.makeVarDeclNode(value);
            }
            return this.makeAssignmentExprNode(value);
        }

        private Node makeVarDeclNode(Node value) {
            Node name = IR.name((String)this.namespace);
            name.addChildToFront(value);
            Node decl = IR.var((Node)name);
            decl.putBooleanProp(Node.IS_NAMESPACE, true);
            if (ProcessClosurePrimitivesWithModuleSupport.this.compiler.getCodingConvention().isConstant(this.namespace)) {
                name.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
            if (this.candidateDefinition == null) {
                decl.setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState(ProcessClosurePrimitivesWithModuleSupport.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private Node makeAssignmentExprNode(Node value) {
            Node lhs = NodeUtil.newQName((AbstractCompiler)ProcessClosurePrimitivesWithModuleSupport.this.compiler, (String)this.namespace, (Node)this.firstNode, (String)this.namespace);
            Node decl = IR.exprResult((Node)IR.assign((Node)lhs, (Node)value));
            decl.putBooleanProp(Node.IS_NAMESPACE, true);
            if (this.candidateDefinition == null) {
                decl.getFirstChild().setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState(ProcessClosurePrimitivesWithModuleSupport.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            lhs.getFirstChild().makeNonIndexableRecursive();
            return decl;
        }

        private void setSourceInfo(Node newNode) {
            Node provideStringNode = this.getProvideStringNode();
            int offset = provideStringNode == null ? 0 : this.getSourceInfoOffset();
            Node sourceInfoNode = provideStringNode == null ? this.firstNode : provideStringNode;
            newNode.useSourceInfoIfMissingFromForTree(sourceInfoNode);
            if (offset != 0) {
                newNode.setSourceEncodedPositionForTree(sourceInfoNode.getSourcePosition() + offset);
            }
        }

        private int getSourceInfoOffset() {
            int indexOfLastDot = this.namespace.lastIndexOf(46);
            return 2 + indexOfLastDot;
        }

        private Node getProvideStringNode() {
            return this.firstNode.getFirstChild() != null && NodeUtil.isExprCall((Node)this.firstNode) ? this.firstNode.getFirstChild().getLastChild() : null;
        }
    }
}

