/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing;

import antlr.Token;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.internal.common.Counter;
import org.apache.royale.compiler.parsing.ICMToken;

public abstract class TokenBase
extends Token
implements ICMToken,
ISourceLocation {
    private CharSequence text;
    private int start;
    private int end;
    private int line;
    private int column;
    private int endLine;
    private int endColumn;
    private boolean locked;
    private int localStart;
    private int localEnd;
    private String sourcePath;

    public TokenBase(int tokenType, int start, int end, int line, int column, CharSequence text) {
        this.type = tokenType;
        this.localStart = this.start = start;
        this.localEnd = this.end = end;
        this.line = line;
        this.column = column;
        this.text = text;
        this.endLine = line;
        this.endColumn = column + end - start;
    }

    public TokenBase(TokenBase o) {
        this.type = o.type;
        this.start = o.start;
        this.end = o.end;
        this.line = o.line;
        this.column = o.column;
        this.endLine = o.endLine;
        this.endColumn = o.endColumn;
        this.text = o.text;
        this.localStart = o.localStart;
        this.localEnd = o.localEnd;
        this.sourcePath = o.sourcePath;
    }

    protected abstract String getTypeString();

    public final int getLocalStart() {
        return this.localStart;
    }

    public final int getLocalEnd() {
        return this.localEnd;
    }

    public final void reuse(int tokenType, int start, int end, int line, int column, CharSequence text) {
        this.type = tokenType;
        this.start = start;
        this.end = end;
        this.line = line;
        this.column = column;
        this.endLine = line;
        this.endColumn = column + end - start;
        this.text = text;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return "";
    }

    public CharSequence getCharSequence() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public void setText(CharSequence text) {
        this.text = text;
    }

    public void setLocation(int start, int end, int line, int column) {
        this.start = start;
        this.end = end;
        this.line = line;
        this.column = column;
        this.endLine = line;
        this.endColumn = column + end - start;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    public final boolean matchesLine(TokenBase other) {
        return other != null && other.line == this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int line) {
        this.endLine = line;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    @Override
    public boolean isImplicit() {
        return this.start == this.end;
    }

    private String getEscapedText() {
        String text = this.getText();
        text = text.replaceAll("\n", "\\\\n");
        text = text.replaceAll("\r", "\\\\r");
        text = text.replaceAll("\t", "\\\\t");
        return text;
    }

    @Override
    public String toString() {
        int line;
        StringBuilder sb = new StringBuilder();
        sb.append('|');
        sb.append(this.getEscapedText());
        sb.append('|');
        sb.append(' ');
        sb.append(this.getTypeString());
        sb.append(' ');
        if (this.locked) {
            sb.append("locked ");
        }
        if ((line = this.getLine()) != -1) {
            sb.append(line + 1);
        } else {
            sb.append('?');
        }
        sb.append(':');
        int column = this.getColumn();
        if (column != -1) {
            sb.append(column + 1);
        } else {
            sb.append('?');
        }
        sb.append(' ');
        int start = this.getStart();
        if (start != -1) {
            sb.append(start);
        } else {
            sb.append('?');
        }
        sb.append('-');
        int end = this.getEnd();
        if (end != -1) {
            sb.append(end);
        } else {
            sb.append('?');
        }
        sb.append(' ');
        String sourcePath = this.getSourcePath();
        if (sourcePath != null) {
            sb.append('\"');
            sb.append(sourcePath);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        return sb.toString();
    }

    public String toDumpString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLine() + 1);
        sb.append('\t');
        sb.append(this.getColumn() + 1);
        sb.append('\t');
        sb.append(this.getStart());
        sb.append('\t');
        sb.append(this.getEnd());
        sb.append('\t');
        String typeString = this.getTypeString();
        sb.append(typeString);
        int n = 28 - typeString.length();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        sb.append('\t');
        sb.append('|');
        sb.append(this.getEscapedText());
        sb.append('|');
        return sb.toString();
    }

    public void truncate(int trimLeft, int trimRight) {
        String text = this.getText();
        if (trimLeft + trimRight <= text.length()) {
            text = text.substring(trimLeft, text.length() - trimRight);
            this.setText(text);
            this.start += trimLeft;
            this.end -= trimRight;
        }
    }

    public void adjustOffsets(int offsetAdjustment) {
        this.start += offsetAdjustment;
        this.end += offsetAdjustment;
    }

    public void adjustLocation(int offsetAdjustment, int lineAdjustment, int columnAdjustment) {
        this.start += offsetAdjustment;
        this.end += offsetAdjustment;
        this.line += lineAdjustment;
        this.column += columnAdjustment;
        this.endLine += lineAdjustment;
        this.endColumn += columnAdjustment;
    }

    public final void storeLocalOffset() {
        this.localStart = this.start;
        this.localEnd = this.end;
    }

    @Override
    public final String getSourcePath() {
        return this.sourcePath;
    }

    public final void setSourcePath(String path) {
        this.sourcePath = path;
    }

    public boolean verify() {
        int type = this.getType();
        assert (type != 0) : "Token has no type: " + this.toString();
        if (type != 1) {
            assert (this.getStart() != -1) : "Token has unknown start: " + this.toString();
            assert (this.getEnd() != -1) : "Token has unknown end: " + this.toString();
            assert (this.getLine() != -1) : "Token has an unknown line: " + this.toString();
            assert (this.getColumn() != -1) : "Token has an unknown column: " + this.toString();
            assert (this.getEndLine() != -1) : "Token has an unknown end line: " + this.toString();
            assert (this.getEndColumn() != -1) : "Token has an unknown end column: " + this.toString();
        }
        return true;
    }

    private void countTokens() {
        if ((CompilerDiagnosticsConstants.diagnostics & 2) == 2) {
            System.out.println("TokenBase incrementing counter for " + this.getClass().getSimpleName());
        }
        Counter counter = Counter.getInstance();
        counter.incrementCount(this.getClass().getSimpleName());
        counter.incrementCount("tokens");
        if ((CompilerDiagnosticsConstants.diagnostics & 2) == 2) {
            System.out.println("TokenBase done incrementing counter for " + this.getClass().getSimpleName());
        }
    }

    @Override
    public int getAbsoluteEnd() {
        return this.getEnd();
    }

    @Override
    public int getAbsoluteStart() {
        return this.getStart();
    }
}

