/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import java.util.Collection;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.SyntaxProblem;

public class MXMLStateSplitter {
    private final String baseName;
    private final String stateName;
    private final int stateNameOffset;

    public MXMLStateSplitter(IMXMLToken nameToken, MXMLDialect mxmlDialect, Collection<ICompilerProblem> problems, IFileSpecification fileSpec) {
        String name = nameToken.getText();
        int i = name.indexOf(46);
        if (i >= 0) {
            if (mxmlDialect != null && mxmlDialect.isEqualToOrAfter(MXMLDialect.MXML_2009)) {
                this.baseName = name.substring(0, i);
                this.stateName = name.substring(i + 1);
                this.stateNameOffset = i + 1;
            } else {
                this.stateNameOffset = -1;
                this.baseName = name;
                this.stateName = null;
                if (problems != null && fileSpec != null) {
                    problems.add(new SyntaxProblem((MXMLToken)nameToken, "Spark state overrides not supported by current language version"));
                }
            }
        } else {
            this.baseName = name;
            this.stateNameOffset = -1;
            this.stateName = null;
        }
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public int getStateNameOffset() {
        return this.stateNameOffset;
    }
}

