/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.ILiteralContainerNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoSparseArrayRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ArrayLiteralID, (node, tokenQuery, problems) -> this.checkLiteralContainerNode((ILiteralContainerNode)node, tokenQuery, problems));
        return result;
    }

    private void checkLiteralContainerNode(ILiteralContainerNode arrayLiteralNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!ILiteralNode.LiteralType.ARRAY.equals((Object)arrayLiteralNode.getLiteralType())) {
            return;
        }
        ContainerNode contentsNode = arrayLiteralNode.getContentsNode();
        if (contentsNode == null) {
            return;
        }
        for (int i = 0; i < contentsNode.getChildCount(); ++i) {
            IASNode child = contentsNode.getChild(i);
            if (!ASTNodeID.NilID.equals((Object)child.getNodeID())) continue;
            problems.add(new NoSparseArrayLinterProblem(arrayLiteralNode));
            return;
        }
    }

    public static class NoSparseArrayLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Array literals must not be sparse";

        public NoSparseArrayLinterProblem(ILiteralContainerNode node) {
            super((ISourceLocation)node);
        }
    }
}

