/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class LiveVariablesAnalysis
extends DataFlowAnalysis<Node, LiveVariableLattice> {
    static final int MAX_VARIABLES_TO_ANALYZE = 100;
    public static final String ARGUMENT_ARRAY_ALIAS = "arguments";
    private final Scope jsScope;
    private final Scope jsScopeChild;
    private final Set<Var> escaped;
    private final Map<String, Integer> scopeVariables;
    private final List<Var> orderedVars;
    private final Map<String, Var> allVarsInFn;

    LiveVariablesAnalysis(ControlFlowGraph<Node> cfg, Scope jsScope, @Nullable Scope jsScopeChild, AbstractCompiler compiler, Es6SyntacticScopeCreator scopeCreator) {
        super(cfg, new LiveVariableJoinOp());
        Preconditions.checkState(jsScope.isFunctionScope(), jsScope);
        this.jsScope = jsScope;
        this.jsScopeChild = jsScopeChild;
        this.escaped = new HashSet<Var>();
        this.scopeVariables = new HashMap<String, Integer>();
        this.allVarsInFn = new HashMap<String, Var>();
        this.orderedVars = new ArrayList<Var>();
        LiveVariablesAnalysis.computeEscaped(jsScope, this.escaped, compiler, scopeCreator);
        NodeUtil.getAllVarsDeclaredInFunction(this.allVarsInFn, this.orderedVars, compiler, scopeCreator, jsScope);
        this.addScopeVariables();
    }

    private void addScopeVariables() {
        int num = 0;
        for (Var v : this.orderedVars) {
            this.scopeVariables.put(v.getName(), num);
            ++num;
        }
    }

    public Set<? extends Var> getEscapedLocals() {
        return this.escaped;
    }

    public Map<String, Var> getAllVariables() {
        return this.allVarsInFn;
    }

    public List<Var> getAllVariablesInOrder() {
        return this.orderedVars;
    }

    public int getVarIndex(String var) {
        return this.scopeVariables.get(var);
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    LiveVariableLattice createEntryLattice() {
        return new LiveVariableLattice(this.orderedVars.size());
    }

    @Override
    LiveVariableLattice createInitialEstimateLattice() {
        return new LiveVariableLattice(this.orderedVars.size());
    }

    @Override
    LiveVariableLattice flowThrough(Node node, LiveVariableLattice input) {
        BitSet gen = new BitSet(input.liveSet.size());
        BitSet kill = new BitSet(input.liveSet.size());
        boolean conditional = false;
        List edgeList = this.getCfg().getOutEdges(node);
        for (DiGraph.DiGraphEdge edge : edgeList) {
            if (!ControlFlowGraph.Branch.ON_EX.equals(edge.getValue())) continue;
            conditional = true;
        }
        this.computeGenKill(node, gen, kill, conditional);
        LiveVariableLattice result = new LiveVariableLattice(input);
        result.liveSet.andNot(kill);
        result.liveSet.or(gen);
        return result;
    }

    private void computeGenKill(Node n, BitSet gen, BitSet kill, boolean conditional) {
        switch (n.getToken()) {
            case SCRIPT: 
            case ROOT: 
            case FUNCTION: 
            case BLOCK: {
                return;
            }
            case WHILE: 
            case DO: 
            case IF: 
            case FOR: {
                this.computeGenKill(NodeUtil.getConditionExpression(n), gen, kill, conditional);
                return;
            }
            case FOR_OF: 
            case FOR_IN: {
                Node lhs = n.getFirstChild();
                if (NodeUtil.isNameDeclaration(lhs)) {
                    lhs = lhs.getLastChild();
                }
                this.computeGenKill(lhs, gen, kill, conditional);
                return;
            }
            case LET: 
            case CONST: 
            case VAR: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (c.isName()) {
                        if (!c.hasChildren()) continue;
                        this.computeGenKill(c.getFirstChild(), gen, kill, conditional);
                        if (conditional) continue;
                        this.addToSetIfLocal(c, kill);
                        continue;
                    }
                    Preconditions.checkState(c.isDestructuringLhs(), c);
                    if (!conditional) {
                        List<Node> allVars = NodeUtil.findLhsNodesInNode(c);
                        for (Node lhsNode : allVars) {
                            this.addToSetIfLocal(lhsNode, kill);
                        }
                    }
                    this.computeGenKill(c.getFirstChild(), gen, kill, conditional);
                    this.computeGenKill(c.getSecondChild(), gen, kill, conditional);
                }
                return;
            }
            case AND: 
            case OR: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case HOOK: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getSecondChild(), gen, kill, true);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case NAME: {
                if (this.isArgumentsName(n)) {
                    this.markAllParametersEscaped();
                } else if (!NodeUtil.isLhsByDestructuring(n)) {
                    this.addToSetIfLocal(n, gen);
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
            Node lhs = n.getFirstChild();
            if (!conditional) {
                this.addToSetIfLocal(lhs, kill);
            }
            if (!n.isAssign()) {
                this.addToSetIfLocal(lhs, gen);
            }
            this.computeGenKill(lhs.getNext(), gen, kill, conditional);
        } else if (n.isAssign() && n.getFirstChild().isDestructuringPattern()) {
            if (!conditional) {
                List<Node> allVars = NodeUtil.findLhsNodesInNode(n);
                for (Node child : allVars) {
                    if (!child.isName()) continue;
                    this.addToSetIfLocal(child, kill);
                }
            }
            this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
            this.computeGenKill(n.getSecondChild(), gen, kill, conditional);
        } else {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                this.computeGenKill(c, gen, kill, conditional);
            }
        }
    }

    private void addToSetIfLocal(Node node, BitSet set) {
        Preconditions.checkState(node.isName(), node);
        String name = node.getString();
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        Scope localScope = (Scope)var.getScope();
        boolean local = localScope.isFunctionBlockScope() ? LiveVariablesAnalysis.isDeclaredInFunctionBlockOrParameter(localScope, name) : (localScope == this.jsScope && this.jsScopeChild != null ? LiveVariablesAnalysis.isDeclaredInFunctionBlockOrParameter(this.jsScopeChild, name) : localScope.hasOwnSlot(name));
        if (!local) {
            return;
        }
        if (!this.escaped.contains(var)) {
            set.set(this.getVarIndex(var.getName()));
        }
    }

    private static boolean isDeclaredInFunctionBlockOrParameter(Scope scope, String name) {
        Preconditions.checkState(scope.isFunctionBlockScope());
        return scope.hasOwnSlot(name) || ((Scope)scope.getParent()).hasOwnSlot(name);
    }

    void markAllParametersEscaped() {
        Node paramList = NodeUtil.getFunctionParameters(this.jsScope.getRootNode());
        for (Node arg = paramList.getFirstChild(); arg != null; arg = arg.getNext()) {
            if (arg.isRest() || arg.isDefaultValue()) {
                this.escaped.add((Var)this.jsScope.getVar(arg.getFirstChild().getString()));
                continue;
            }
            this.escaped.add((Var)this.jsScope.getVar(arg.getString()));
        }
    }

    private boolean isArgumentsName(Node n) {
        boolean childDeclared = this.jsScopeChild != null ? this.jsScopeChild.hasOwnSlot(ARGUMENT_ARRAY_ALIAS) : true;
        return n.isName() && n.getString().equals(ARGUMENT_ARRAY_ALIAS) && (!this.jsScope.hasOwnSlot(ARGUMENT_ARRAY_ALIAS) || !childDeclared);
    }

    static class LiveVariableLattice
    implements LatticeElement {
        private final BitSet liveSet;

        private LiveVariableLattice(int numVars) {
            this.liveSet = new BitSet(numVars);
        }

        private LiveVariableLattice(LiveVariableLattice other) {
            Preconditions.checkNotNull(other);
            this.liveSet = (BitSet)other.liveSet.clone();
        }

        public boolean equals(Object other) {
            Preconditions.checkNotNull(other);
            return other instanceof LiveVariableLattice && this.liveSet.equals(((LiveVariableLattice)other).liveSet);
        }

        public boolean isLive(int index) {
            return this.liveSet.get(index);
        }

        public String toString() {
            return this.liveSet.toString();
        }

        public int hashCode() {
            return this.liveSet.hashCode();
        }
    }

    private static class LiveVariableJoinOp
    implements JoinOp<LiveVariableLattice> {
        private LiveVariableJoinOp() {
        }

        @Override
        public LiveVariableLattice apply(List<LiveVariableLattice> in) {
            LiveVariableLattice result = new LiveVariableLattice(in.get(0));
            for (int i = 1; i < in.size(); ++i) {
                result.liveSet.or(in.get(i).liveSet);
            }
            return result;
        }
    }
}

