/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.common.TopicAttributes;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.constant.PermName;

public class TopicConfig {
    private static final String SEPARATOR = " ";
    public static int defaultReadQueueNums = 16;
    public static int defaultWriteQueueNums = 16;
    private static final TypeReference<Map<String, String>> ATTRIBUTES_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};
    private String topicName;
    private int readQueueNums = defaultReadQueueNums;
    private int writeQueueNums = defaultWriteQueueNums;
    private int perm = 6;
    private TopicFilterType topicFilterType = TopicFilterType.SINGLE_TAG;
    private int topicSysFlag = 0;
    private boolean order = false;
    private Map<String, String> attributes = new HashMap<String, String>();

    public TopicConfig() {
    }

    public TopicConfig(String topicName) {
        this.topicName = topicName;
    }

    public TopicConfig(String topicName, int readQueueNums, int writeQueueNums) {
        this.topicName = topicName;
        this.readQueueNums = readQueueNums;
        this.writeQueueNums = writeQueueNums;
    }

    public TopicConfig(String topicName, int readQueueNums, int writeQueueNums, int perm) {
        this.topicName = topicName;
        this.readQueueNums = readQueueNums;
        this.writeQueueNums = writeQueueNums;
        this.perm = perm;
    }

    public TopicConfig(String topicName, int readQueueNums, int writeQueueNums, int perm, int topicSysFlag) {
        this.topicName = topicName;
        this.readQueueNums = readQueueNums;
        this.writeQueueNums = writeQueueNums;
        this.perm = perm;
        this.topicSysFlag = topicSysFlag;
    }

    public TopicConfig(TopicConfig other) {
        this.topicName = other.topicName;
        this.readQueueNums = other.readQueueNums;
        this.writeQueueNums = other.writeQueueNums;
        this.perm = other.perm;
        this.topicFilterType = other.topicFilterType;
        this.topicSysFlag = other.topicSysFlag;
        this.order = other.order;
        this.attributes = other.attributes;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.topicName);
        sb.append(SEPARATOR);
        sb.append(this.readQueueNums);
        sb.append(SEPARATOR);
        sb.append(this.writeQueueNums);
        sb.append(SEPARATOR);
        sb.append(this.perm);
        sb.append(SEPARATOR);
        sb.append((Object)this.topicFilterType);
        sb.append(SEPARATOR);
        if (this.attributes != null) {
            sb.append(JSON.toJSONString(this.attributes));
        }
        return sb.toString();
    }

    public boolean decode(String in) {
        String[] strs = in.split(SEPARATOR);
        if (strs.length >= 5) {
            this.topicName = strs[0];
            this.readQueueNums = Integer.parseInt(strs[1]);
            this.writeQueueNums = Integer.parseInt(strs[2]);
            this.perm = Integer.parseInt(strs[3]);
            this.topicFilterType = TopicFilterType.valueOf(strs[4]);
            if (strs.length >= 6) {
                try {
                    this.attributes = (Map)JSON.parseObject((String)strs[5], (Type)ATTRIBUTES_TYPE_REFERENCE.getType(), (Feature[])new Feature[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public int getReadQueueNums() {
        return this.readQueueNums;
    }

    public void setReadQueueNums(int readQueueNums) {
        this.readQueueNums = readQueueNums;
    }

    public int getWriteQueueNums() {
        return this.writeQueueNums;
    }

    public void setWriteQueueNums(int writeQueueNums) {
        this.writeQueueNums = writeQueueNums;
    }

    public int getPerm() {
        return this.perm;
    }

    public void setPerm(int perm) {
        this.perm = perm;
    }

    public TopicFilterType getTopicFilterType() {
        return this.topicFilterType;
    }

    public void setTopicFilterType(TopicFilterType topicFilterType) {
        this.topicFilterType = topicFilterType;
    }

    public int getTopicSysFlag() {
        return this.topicSysFlag;
    }

    public void setTopicSysFlag(int topicSysFlag) {
        this.topicSysFlag = topicSysFlag;
    }

    public boolean isOrder() {
        return this.order;
    }

    public void setOrder(boolean isOrder) {
        this.order = isOrder;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @JSONField(serialize=false, deserialize=false)
    public TopicMessageType getTopicMessageType() {
        if (this.attributes == null) {
            return TopicMessageType.NORMAL;
        }
        String content = this.attributes.get(TopicAttributes.TOPIC_MESSAGE_TYPE_ATTRIBUTE.getName());
        if (content == null) {
            return TopicMessageType.NORMAL;
        }
        return TopicMessageType.valueOf(content);
    }

    @JSONField(serialize=false, deserialize=false)
    public void setTopicMessageType(TopicMessageType topicMessageType) {
        this.attributes.put(TopicAttributes.TOPIC_MESSAGE_TYPE_ATTRIBUTE.getName(), topicMessageType.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicConfig that = (TopicConfig)o;
        if (this.readQueueNums != that.readQueueNums) {
            return false;
        }
        if (this.writeQueueNums != that.writeQueueNums) {
            return false;
        }
        if (this.perm != that.perm) {
            return false;
        }
        if (this.topicSysFlag != that.topicSysFlag) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (!Objects.equals(this.topicName, that.topicName)) {
            return false;
        }
        if (this.topicFilterType != that.topicFilterType) {
            return false;
        }
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        int result = this.topicName != null ? this.topicName.hashCode() : 0;
        result = 31 * result + this.readQueueNums;
        result = 31 * result + this.writeQueueNums;
        result = 31 * result + this.perm;
        result = 31 * result + (this.topicFilterType != null ? this.topicFilterType.hashCode() : 0);
        result = 31 * result + this.topicSysFlag;
        result = 31 * result + (this.order ? 1 : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TopicConfig [topicName=" + this.topicName + ", readQueueNums=" + this.readQueueNums + ", writeQueueNums=" + this.writeQueueNums + ", perm=" + PermName.perm2String(this.perm) + ", topicFilterType=" + (Object)((Object)this.topicFilterType) + ", topicSysFlag=" + this.topicSysFlag + ", order=" + this.order + ", attributes=" + this.attributes + "]";
    }
}

