/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.channel;

import apache.rocketmq.v2.PrintThreadStackTraceCommand;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.VerifyMessageCommand;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.channel.ChannelHelper;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.processor.channel.ChannelExtendAttributeGetter;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannel;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannelConverter;
import org.apache.rocketmq.proxy.service.relay.ProxyChannel;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayResult;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.proxy.service.transaction.TransactionData;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerRunningInfoRequestHeader;

public class GrpcClientChannel
extends ProxyChannel
implements ChannelExtendAttributeGetter,
RemoteChannelConverter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final GrpcChannelManager grpcChannelManager;
    private final GrpcClientSettingsManager grpcClientSettingsManager;
    private final AtomicReference<StreamObserver<TelemetryCommand>> telemetryCommandRef = new AtomicReference();
    private final Object telemetryWriteLock = new Object();
    private final String clientId;

    public GrpcClientChannel(ProxyRelayService proxyRelayService, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager, ProxyContext ctx, String clientId) {
        super(proxyRelayService, null, new GrpcChannelId(clientId), ctx.getRemoteAddress(), ctx.getLocalAddress());
        this.grpcChannelManager = grpcChannelManager;
        this.grpcClientSettingsManager = grpcClientSettingsManager;
        this.clientId = clientId;
    }

    @Override
    public String getChannelExtendAttribute() {
        Settings settings = this.grpcClientSettingsManager.getRawClientSettings(this.clientId);
        if (settings == null) {
            return null;
        }
        try {
            return JsonFormat.printer().print((MessageOrBuilder)settings);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("convert settings to json data failed. settings:{}", (Object)settings, (Object)e);
            return null;
        }
    }

    public static Settings parseChannelExtendAttribute(Channel channel) {
        if (ChannelHelper.getChannelProtocolType(channel).equals((Object)ChannelProtocolType.GRPC_V2) && channel instanceof ChannelExtendAttributeGetter) {
            String attr = ((ChannelExtendAttributeGetter)channel).getChannelExtendAttribute();
            if (attr == null) {
                return null;
            }
            Settings.Builder builder = Settings.newBuilder();
            try {
                JsonFormat.parser().merge(attr, (Message.Builder)builder);
                return builder.build();
            }
            catch (InvalidProtocolBufferException e) {
                log.error("convert settings json data to settings failed. data:{}", (Object)attr, (Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public RemoteChannel toRemoteChannel() {
        return new RemoteChannel(ConfigurationManager.getProxyConfig().getLocalServeAddr(), this.getRemoteAddress(), this.getLocalAddress(), ChannelProtocolType.GRPC_V2, this.getChannelExtendAttribute());
    }

    public void setClientObserver(StreamObserver<TelemetryCommand> future) {
        this.telemetryCommandRef.set(future);
    }

    protected void clearClientObserver(StreamObserver<TelemetryCommand> future) {
        this.telemetryCommandRef.compareAndSet(future, null);
    }

    @Override
    public boolean isOpen() {
        return this.telemetryCommandRef.get() != null;
    }

    @Override
    public boolean isActive() {
        return this.telemetryCommandRef.get() != null;
    }

    @Override
    public boolean isWritable() {
        return this.telemetryCommandRef.get() != null;
    }

    @Override
    protected CompletableFuture<Void> processOtherMessage(Object msg) {
        if (msg instanceof TelemetryCommand) {
            TelemetryCommand response = (TelemetryCommand)msg;
            this.writeTelemetryCommand(response);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> processCheckTransaction(CheckTransactionStateRequestHeader header, MessageExt messageExt, TransactionData transactionData, CompletableFuture<ProxyRelayResult<Void>> responseFuture) {
        CompletableFuture<Void> writeFuture = new CompletableFuture<Void>();
        try {
            this.writeTelemetryCommand(TelemetryCommand.newBuilder().setRecoverOrphanedTransactionCommand(RecoverOrphanedTransactionCommand.newBuilder().setTransactionId(transactionData.getTransactionId()).setMessage(GrpcConverter.getInstance().buildMessage(messageExt)).build()).build());
            responseFuture.complete(null);
            writeFuture.complete(null);
        }
        catch (Throwable t) {
            responseFuture.completeExceptionally(t);
            writeFuture.completeExceptionally(t);
        }
        return writeFuture;
    }

    @Override
    protected CompletableFuture<Void> processGetConsumerRunningInfo(RemotingCommand command, GetConsumerRunningInfoRequestHeader header, CompletableFuture<ProxyRelayResult<ConsumerRunningInfo>> responseFuture) {
        if (Objects.isNull(header) || !header.isJstackEnable()) {
            return CompletableFuture.completedFuture(null);
        }
        this.writeTelemetryCommand(TelemetryCommand.newBuilder().setPrintThreadStackTraceCommand(PrintThreadStackTraceCommand.newBuilder().setNonce(this.grpcChannelManager.addResponseFuture(responseFuture)).build()).build());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> processConsumeMessageDirectly(RemotingCommand command, ConsumeMessageDirectlyResultRequestHeader header, MessageExt messageExt, CompletableFuture<ProxyRelayResult<ConsumeMessageDirectlyResult>> responseFuture) {
        this.writeTelemetryCommand(TelemetryCommand.newBuilder().setVerifyMessageCommand(VerifyMessageCommand.newBuilder().setNonce(this.grpcChannelManager.addResponseFuture(responseFuture)).setMessage(GrpcConverter.getInstance().buildMessage(messageExt)).build()).build());
        return CompletableFuture.completedFuture(null);
    }

    public String getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTelemetryCommand(TelemetryCommand command) {
        StreamObserver<TelemetryCommand> observer = this.telemetryCommandRef.get();
        if (observer == null) {
            log.warn("telemetry command observer is null when try to write data. command:{}, channel:{}", (Object)TextFormat.shortDebugString((MessageOrBuilder)command), (Object)this);
            return;
        }
        Object object = this.telemetryWriteLock;
        synchronized (object) {
            observer = this.telemetryCommandRef.get();
            if (observer == null) {
                log.warn("telemetry command observer is null when try to write data. command:{}, channel:{}", (Object)TextFormat.shortDebugString((MessageOrBuilder)command), (Object)this);
                return;
            }
            try {
                observer.onNext((Object)command);
            }
            catch (StatusRuntimeException | IllegalStateException exception) {
                log.warn("write telemetry failed. command:{}", (Object)command, (Object)exception);
                this.clearClientObserver(observer);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("remoteAddress", (Object)this.getRemoteAddress()).add("localAddress", (Object)this.getLocalAddress()).toString();
    }

    protected static class GrpcChannelId
    implements ChannelId {
        private final String clientId;

        public GrpcChannelId(String clientId) {
            this.clientId = clientId;
        }

        public String asShortText() {
            return this.clientId;
        }

        public String asLongText() {
            return this.clientId;
        }

        public int compareTo(ChannelId o) {
            if (this == o) {
                return 0;
            }
            if (o instanceof GrpcChannelId) {
                GrpcChannelId other = (GrpcChannelId)o;
                return ComparisonChain.start().compare((Comparable)((Object)this.clientId), (Comparable)((Object)other.clientId)).result();
            }
            return this.asLongText().compareTo(o.asLongText());
        }
    }
}

