/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v2;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.common.config.ConfigHelper;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.FlushOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class ConfigStorage
extends AbstractRocksDBStorage {
    public static final String DATA_VERSION_KEY = "data_version";
    public static final byte[] DATA_VERSION_KEY_BYTES = "data_version".getBytes(StandardCharsets.UTF_8);
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicInteger writeOpsCounter;
    private final AtomicLong estimateWalFileSize = new AtomicLong(0L);
    private final MessageStoreConfig messageStoreConfig;
    private final FlushSyncService flushSyncService;

    public ConfigStorage(MessageStoreConfig messageStoreConfig) {
        super(messageStoreConfig.getStorePathRootDir() + File.separator + "config" + File.separator + "rdb");
        this.messageStoreConfig = messageStoreConfig;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("config-storage-%d").build();
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.writeOpsCounter = new AtomicInteger(0);
        this.flushSyncService = new FlushSyncService();
        this.flushSyncService.setDaemon(true);
    }

    private void statNettyMemory() {
        PooledByteBufAllocatorMetric metric = AbstractRocksDBStorage.POOLED_ALLOCATOR.metric();
        LOGGER.info("Netty Memory Usage: {}", (Object)metric);
    }

    public synchronized boolean start() {
        boolean started = super.start();
        if (started) {
            this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.statRocksdb(LOGGER), 1L, 10L, TimeUnit.SECONDS);
            this.scheduledExecutorService.scheduleWithFixedDelay(this::statNettyMemory, 10L, 10L, TimeUnit.SECONDS);
            this.flushSyncService.start();
        } else {
            LOGGER.error("Failed to start config storage");
        }
        return started;
    }

    protected boolean postLoad() {
        if (!PlatformDependent.hasUnsafe()) {
            LOGGER.error("Unsafe not available and POOLED_ALLOCATOR cannot work correctly");
            return false;
        }
        try {
            UtilAll.ensureDirOK((String)this.dbPath);
            this.initOptions();
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            ColumnFamilyOptions defaultOptions = ConfigHelper.createConfigColumnFamilyOptions();
            this.cfOptions.add(defaultOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, defaultOptions));
            this.open(cfDescriptors);
            this.defaultCFHandle = (ColumnFamilyHandle)this.cfHandles.get(0);
        }
        catch (Exception e) {
            AbstractRocksDBStorage.LOGGER.error("postLoad Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    protected void preShutdown() {
        this.scheduledExecutorService.shutdown();
        this.flushSyncService.shutdown();
    }

    protected void initOptions() {
        this.options = ConfigHelper.createConfigDBOptions();
        super.initOptions();
    }

    protected void initAbleWalWriteOptions() {
        this.ableWalWriteOptions = new WriteOptions();
        this.ableWalWriteOptions.setSync(false);
        this.ableWalWriteOptions.setDisableWAL(false);
        this.ableWalWriteOptions.setNoSlowdown(false);
    }

    public byte[] get(ByteBuffer key) throws RocksDBException {
        byte[] keyBytes = new byte[key.remaining()];
        key.get(keyBytes);
        return super.get(this.getDefaultCFHandle(), this.totalOrderReadOptions, keyBytes);
    }

    public void write(WriteBatch writeBatch) throws RocksDBException {
        this.db.write(this.ableWalWriteOptions, writeBatch);
        this.accountWriteOps(writeBatch.getDataSize());
    }

    private void accountWriteOps(long dataSize) {
        this.writeOpsCounter.incrementAndGet();
        this.estimateWalFileSize.addAndGet(dataSize);
    }

    public RocksIterator iterate(ByteBuffer beginKey, ByteBuffer endKey) {
        try (ReadOptions readOptions = new ReadOptions();){
            readOptions.setTotalOrderSeek(true);
            readOptions.setTailing(false);
            readOptions.setAutoPrefixMode(true);
            byte[] buf = new byte[endKey.remaining()];
            endKey.slice().get(buf);
            readOptions.setIterateUpperBound((AbstractSlice)new Slice(buf));
            RocksIterator iterator = this.db.newIterator(this.defaultCFHandle, readOptions);
            iterator.seek(beginKey.slice());
            RocksIterator rocksIterator = iterator;
            return rocksIterator;
        }
    }

    class FlushSyncService
    extends ServiceThread {
        private long lastSyncTime = 0L;
        private static final long MAX_SYNC_INTERVAL_IN_MILLIS = 100L;
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        private final FlushOptions flushOptions = new FlushOptions();

        FlushSyncService() {
        }

        public String getServiceName() {
            return "FlushSyncService";
        }

        public void run() {
            this.flushOptions.setAllowWriteStall(false);
            this.flushOptions.setWaitForFlush(true);
            log.info("{} service started", (Object)this.getServiceName());
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(10L);
                    this.flushAndSyncWAL(false);
                }
                catch (Exception e) {
                    log.warn("{} service has exception. ", (Object)this.getServiceName(), (Object)e);
                }
            }
            try {
                this.flushAndSyncWAL(true);
            }
            catch (Exception e) {
                log.warn("{} raised an exception while performing flush-and-sync WAL on exit", (Object)this.getServiceName(), (Object)e);
            }
            this.flushOptions.close();
            log.info("{} service end", (Object)this.getServiceName());
        }

        private void flushAndSyncWAL(boolean onExit) throws RocksDBException {
            int writeOps = ConfigStorage.this.writeOpsCounter.get();
            if (0 == writeOps) {
                return;
            }
            if (ConfigStorage.this.estimateWalFileSize.get() >= ConfigStorage.this.messageStoreConfig.getRocksdbWalFileRollingThreshold()) {
                ConfigStorage.this.flush(this.flushOptions);
                ConfigStorage.this.estimateWalFileSize.set(0L);
            }
            if (writeOps >= ConfigStorage.this.messageStoreConfig.getRocksdbFlushWalFrequency() || onExit) {
                this.stopwatch.reset().start();
                ConfigStorage.this.db.flushWal(true);
                long elapsed = this.stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                ConfigStorage.this.writeOpsCounter.getAndAdd(-writeOps);
                this.lastSyncTime = System.currentTimeMillis();
                LOGGER.debug("Flush and Sync WAL of RocksDB[{}] costs {}ms, write-ops={}", new Object[]{ConfigStorage.this.dbPath, elapsed, writeOps});
                return;
            }
            long elapsedTime = System.currentTimeMillis() - this.lastSyncTime;
            if (elapsedTime > 100L) {
                this.stopwatch.reset().start();
                ConfigStorage.this.db.flushWal(true);
                long elapsed = this.stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                LOGGER.debug("Flush and Sync WAL of RocksDB[{}] costs {}ms, write-ops={}", new Object[]{ConfigStorage.this.dbPath, elapsed, writeOps});
                ConfigStorage.this.writeOpsCounter.getAndAdd(-writeOps);
                this.lastSyncTime = System.currentTimeMillis();
            }
        }
    }
}

