/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.interceptors.BaseUrlHandler;
import com.microsoft.rest.interceptors.CustomHeadersInterceptor;
import com.microsoft.rest.interceptors.LoggingInterceptor;
import com.microsoft.rest.interceptors.RequestIdHeaderInterceptor;
import com.microsoft.rest.interceptors.UserAgentInterceptor;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.rest.retry.RetryHandler;
import com.microsoft.rest.retry.RetryStrategy;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.Proxy;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okio.AsyncTimeout;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;

public final class RestClient {
    private final OkHttpClient httpClient;
    private final Retrofit retrofit;
    private final Builder builder;

    private RestClient(OkHttpClient httpClient, Retrofit retrofit, Builder builder) {
        this.httpClient = httpClient;
        this.retrofit = retrofit;
        this.builder = builder;
    }

    public CustomHeadersInterceptor headers() {
        return this.builder.customHeadersInterceptor;
    }

    public SerializerAdapter<?> serializerAdapter() {
        return this.builder.serializerAdapter;
    }

    public ResponseBuilder.Factory responseBuilderFactory() {
        return this.builder.responseBuilderFactory;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public Retrofit retrofit() {
        return this.retrofit;
    }

    public ServiceClientCredentials credentials() {
        return this.builder.credentials;
    }

    public LogLevel logLevel() {
        return this.builder.loggingInterceptor.logLevel();
    }

    public RestClient withLogLevel(LogLevel logLevel) {
        this.builder.loggingInterceptor.withLogLevel(logLevel);
        return this;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta(value=Beta.SinceVersion.V1_1_0)
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        Object object = this.httpClient.connectionPool();
        synchronized (object) {
            this.httpClient.connectionPool().notifyAll();
        }
        object = AsyncTimeout.class;
        synchronized (AsyncTimeout.class) {
            AsyncTimeout.class.notifyAll();
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public void closeAndWait() throws InterruptedException {
        this.close();
        Thread.sleep(60000L);
    }

    public static class Builder {
        private String baseUrl;
        private OkHttpClient.Builder httpClientBuilder;
        private Retrofit.Builder retrofitBuilder;
        private ServiceClientCredentials credentials;
        private Interceptor credentialsInterceptor;
        private CustomHeadersInterceptor customHeadersInterceptor;
        private String userAgent;
        private SerializerAdapter<?> serializerAdapter;
        private ResponseBuilder.Factory responseBuilderFactory;
        private LoggingInterceptor loggingInterceptor;
        private RetryStrategy retryStrategy;
        private Dispatcher dispatcher;
        private boolean useHttpClientThreadPool;
        private ConnectionPool connectionPool;

        public Builder() {
            this(new OkHttpClient.Builder(), new Retrofit.Builder());
        }

        private Builder(RestClient restClient) {
            this(restClient.httpClient.newBuilder(), new Retrofit.Builder());
            this.httpClientBuilder.readTimeout((long)restClient.httpClient.readTimeoutMillis(), TimeUnit.MILLISECONDS);
            this.httpClientBuilder.connectTimeout((long)restClient.httpClient.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
            this.httpClientBuilder.interceptors().clear();
            this.httpClientBuilder.networkInterceptors().clear();
            this.baseUrl = restClient.retrofit.baseUrl().toString();
            this.responseBuilderFactory = ((RestClient)restClient).builder.responseBuilderFactory;
            this.serializerAdapter = ((RestClient)restClient).builder.serializerAdapter;
            this.useHttpClientThreadPool = ((RestClient)restClient).builder.useHttpClientThreadPool;
            if (((RestClient)restClient).builder.credentials != null) {
                this.credentials = ((RestClient)restClient).builder.credentials;
            }
            if (restClient.retrofit.callbackExecutor() != null) {
                this.withCallbackExecutor(restClient.retrofit.callbackExecutor());
            }
            for (Interceptor interceptor : restClient.httpClient.interceptors()) {
                if (interceptor instanceof UserAgentInterceptor) {
                    this.userAgent = ((UserAgentInterceptor)interceptor).userAgent();
                    continue;
                }
                if (interceptor instanceof RetryHandler) {
                    this.retryStrategy = ((RetryHandler)interceptor).strategy();
                    continue;
                }
                if (interceptor instanceof CustomHeadersInterceptor) {
                    this.customHeadersInterceptor = new CustomHeadersInterceptor();
                    this.customHeadersInterceptor.addHeaderMultimap(((CustomHeadersInterceptor)interceptor).headers());
                    continue;
                }
                if (interceptor == ((RestClient)restClient).builder.credentialsInterceptor) continue;
                this.withInterceptor(interceptor);
            }
            for (Interceptor interceptor : restClient.httpClient.networkInterceptors()) {
                if (interceptor instanceof LoggingInterceptor) {
                    LoggingInterceptor old = (LoggingInterceptor)interceptor;
                    this.loggingInterceptor = new LoggingInterceptor(old.logLevel());
                    continue;
                }
                this.withNetworkInterceptor(interceptor);
            }
        }

        public Builder(OkHttpClient.Builder httpClientBuilder, Retrofit.Builder retrofitBuilder) {
            if (httpClientBuilder == null) {
                throw new IllegalArgumentException("httpClientBuilder == null");
            }
            if (retrofitBuilder == null) {
                throw new IllegalArgumentException("retrofitBuilder == null");
            }
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            this.customHeadersInterceptor = new CustomHeadersInterceptor();
            this.httpClientBuilder = httpClientBuilder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).readTimeout(120L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)new RequestIdHeaderInterceptor()).addInterceptor((Interceptor)new BaseUrlHandler());
            this.retrofitBuilder = retrofitBuilder;
            this.loggingInterceptor = new LoggingInterceptor(LogLevel.NONE);
            this.useHttpClientThreadPool = false;
        }

        public Builder withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withBaseUrl(Environment environment, Environment.Endpoint endpoint) {
            this.baseUrl = environment.url(endpoint);
            return this;
        }

        public Builder withSerializerAdapter(SerializerAdapter<?> serializerAdapter) {
            this.serializerAdapter = serializerAdapter;
            return this;
        }

        public Builder withResponseBuilderFactory(ResponseBuilder.Factory responseBuilderFactory) {
            this.responseBuilderFactory = responseBuilderFactory;
            return this;
        }

        public Builder withCredentials(ServiceClientCredentials credentials) {
            if (credentials == null) {
                throw new NullPointerException("credentials == null");
            }
            this.credentials = credentials;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder withLogLevel(LogLevel logLevel) {
            if (logLevel == null) {
                throw new NullPointerException("logLevel == null");
            }
            this.loggingInterceptor.withLogLevel(logLevel);
            return this;
        }

        public Builder withInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor == null");
            }
            this.httpClientBuilder.addInterceptor(interceptor);
            return this;
        }

        public Builder withNetworkInterceptor(Interceptor networkInterceptor) {
            if (networkInterceptor == null) {
                throw new NullPointerException("networkInterceptor == null");
            }
            this.httpClientBuilder.addNetworkInterceptor(networkInterceptor);
            return this;
        }

        public Builder withReadTimeout(long timeout, TimeUnit unit) {
            this.httpClientBuilder.readTimeout(timeout, unit);
            return this;
        }

        public Builder withConnectionTimeout(long timeout, TimeUnit unit) {
            this.httpClientBuilder.connectTimeout(timeout, unit);
            return this;
        }

        @Deprecated
        public Builder withMaxIdleConnections(int maxIdleConnections) {
            this.connectionPool = new ConnectionPool(maxIdleConnections, 5L, TimeUnit.MINUTES);
            return this;
        }

        public Builder withConnectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public Builder useHttpClientThreadPool(boolean useHttpClientThreadPool) {
            this.useHttpClientThreadPool = useHttpClientThreadPool;
            return this;
        }

        public Builder withDispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder withCallbackExecutor(Executor executor) {
            this.retrofitBuilder.callbackExecutor(executor);
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.httpClientBuilder.proxy(proxy);
            return this;
        }

        public Builder withProxyAuthenticator(Authenticator proxyAuthenticator) {
            this.httpClientBuilder.proxyAuthenticator(proxyAuthenticator);
            return this;
        }

        public Builder withRetryStrategy(RetryStrategy strategy) {
            this.retryStrategy = strategy;
            return this;
        }

        public RestClient build() {
            UserAgentInterceptor userAgentInterceptor = new UserAgentInterceptor();
            if (this.userAgent != null) {
                userAgentInterceptor.withUserAgent(this.userAgent);
            }
            if (this.baseUrl == null) {
                throw new IllegalArgumentException("Please set base URL.");
            }
            if (!this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            if (this.responseBuilderFactory == null) {
                throw new IllegalArgumentException("Please set response builder factory.");
            }
            if (this.serializerAdapter == null) {
                throw new IllegalArgumentException("Please set serializer adapter.");
            }
            if (this.credentials != null) {
                int interceptorCount = this.httpClientBuilder.interceptors().size();
                this.credentials.applyCredentialsFilter(this.httpClientBuilder);
                if (this.httpClientBuilder.interceptors().size() > interceptorCount) {
                    this.credentialsInterceptor = (Interceptor)this.httpClientBuilder.interceptors().get(interceptorCount);
                }
            }
            RetryHandler retryHandler = this.retryStrategy == null ? new RetryHandler() : new RetryHandler(this.retryStrategy);
            if (this.connectionPool != null) {
                this.httpClientBuilder = this.httpClientBuilder.connectionPool(this.connectionPool);
            }
            if (this.dispatcher != null) {
                this.httpClientBuilder = this.httpClientBuilder.dispatcher(this.dispatcher);
            }
            OkHttpClient httpClient = this.httpClientBuilder.addInterceptor((Interceptor)userAgentInterceptor).addInterceptor((Interceptor)this.customHeadersInterceptor).addInterceptor((Interceptor)retryHandler).addNetworkInterceptor((Interceptor)this.loggingInterceptor).build();
            RxJavaCallAdapterFactory callAdapterFactory = this.useHttpClientThreadPool ? RxJavaCallAdapterFactory.createAsync() : RxJavaCallAdapterFactory.create();
            return new RestClient(httpClient, this.retrofitBuilder.baseUrl(this.baseUrl).client(httpClient).addConverterFactory(this.serializerAdapter.converterFactory()).addCallAdapterFactory((CallAdapter.Factory)callAdapterFactory).build(), this);
        }
    }
}

