/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.Queue;
import com.microsoft.azure.management.servicebus.Queues;
import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.management.servicebus.implementation.QueueImpl;
import com.microsoft.azure.management.servicebus.implementation.QueueInner;
import com.microsoft.azure.management.servicebus.implementation.QueuesInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;

@LangDefinition
class QueuesImpl
extends ServiceBusChildResourcesImpl<Queue, QueueImpl, QueueInner, QueuesInner, ServiceBusManager, ServiceBusNamespace>
implements Queues {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;

    QueuesImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClientImpl)((Object)manager.inner())).queues(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    public QueueImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByNameAsync(String name) {
        return ((QueuesInner)this.inner()).deleteAsync(this.resourceGroupName, this.namespaceName, name).toCompletable();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((QueuesInner)this.inner()).deleteAsync(this.resourceGroupName, this.namespaceName, name, callback);
    }

    @Override
    protected Observable<QueueInner> getInnerByNameAsync(String name) {
        return ((QueuesInner)this.inner()).getAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Observable<ServiceResponse<Page<QueueInner>>> listInnerAsync() {
        return ((QueuesInner)this.inner()).listByNamespaceWithServiceResponseAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedList<QueueInner> listInner() {
        return ((QueuesInner)this.inner()).listByNamespace(this.resourceGroupName, this.namespaceName);
    }

    protected QueueImpl wrapModel(String name) {
        return new QueueImpl(this.resourceGroupName, this.namespaceName, name, this.region, new QueueInner(), (ServiceBusManager)this.manager());
    }

    protected QueueImpl wrapModel(QueueInner inner) {
        if (inner == null) {
            return null;
        }
        return new QueueImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedList<Queue> listByParent(String resourceGroupName, String parentName) {
        throw new UnsupportedOperationException();
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        throw new UnsupportedOperationException();
    }

    public Observable<Queue> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw new UnsupportedOperationException();
    }
}

