/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.cdn.CheckNameAvailabilityInput;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.ValidateProbeInput;
import com.microsoft.azure.management.cdn.implementation.CheckNameAvailabilityOutputInner;
import com.microsoft.azure.management.cdn.implementation.CustomDomainsInner;
import com.microsoft.azure.management.cdn.implementation.EdgeNodesInner;
import com.microsoft.azure.management.cdn.implementation.EndpointsInner;
import com.microsoft.azure.management.cdn.implementation.OperationsInner;
import com.microsoft.azure.management.cdn.implementation.OriginsInner;
import com.microsoft.azure.management.cdn.implementation.ProfilesInner;
import com.microsoft.azure.management.cdn.implementation.ResourceUsagesInner;
import com.microsoft.azure.management.cdn.implementation.ValidateProbeOutputInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class CdnManagementClientImpl
extends AzureServiceClient {
    private CdnManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ProfilesInner profiles;
    private EndpointsInner endpoints;
    private OriginsInner origins;
    private CustomDomainsInner customDomains;
    private ResourceUsagesInner resourceUsages;
    private OperationsInner operations;
    private EdgeNodesInner edgeNodes;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public CdnManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public CdnManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public CdnManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public CdnManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ProfilesInner profiles() {
        return this.profiles;
    }

    public EndpointsInner endpoints() {
        return this.endpoints;
    }

    public OriginsInner origins() {
        return this.origins;
    }

    public CustomDomainsInner customDomains() {
        return this.customDomains;
    }

    public ResourceUsagesInner resourceUsages() {
        return this.resourceUsages;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public EdgeNodesInner edgeNodes() {
        return this.edgeNodes;
    }

    public CdnManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public CdnManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public CdnManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2017-10-12";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.profiles = new ProfilesInner(this.restClient().retrofit(), this);
        this.endpoints = new EndpointsInner(this.restClient().retrofit(), this);
        this.origins = new OriginsInner(this.restClient().retrofit(), this);
        this.customDomains = new CustomDomainsInner(this.restClient().retrofit(), this);
        this.resourceUsages = new ResourceUsagesInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.edgeNodes = new EdgeNodesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "CdnManagementClient", "2017-10-12");
    }

    private void initializeService() {
        this.service = (CdnManagementClientService)this.restClient().retrofit().create(CdnManagementClientService.class);
    }

    public CheckNameAvailabilityOutputInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityOutputInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityOutputInner>, CheckNameAvailabilityOutputInner>(){

            public CheckNameAvailabilityOutputInner call(ServiceResponse<CheckNameAvailabilityOutputInner> response) {
                return (CheckNameAvailabilityOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return this.service.checkNameAvailability(this.apiVersion(), this.acceptLanguage(), checkNameAvailabilityInput, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityOutputInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CdnManagementClientImpl.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityOutputInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityOutputInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CheckNameAvailabilityOutputInner checkNameAvailabilityWithSubscription(String name) {
        return (CheckNameAvailabilityOutputInner)((ServiceResponse)this.checkNameAvailabilityWithSubscriptionWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionAsync(String name, ServiceCallback<CheckNameAvailabilityOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithSubscriptionWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionAsync(String name) {
        return this.checkNameAvailabilityWithSubscriptionWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityOutputInner>, CheckNameAvailabilityOutputInner>(){

            public CheckNameAvailabilityOutputInner call(ServiceResponse<CheckNameAvailabilityOutputInner> response) {
                return (CheckNameAvailabilityOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscriptionWithServiceResponseAsync(String name) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return this.service.checkNameAvailabilityWithSubscription(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), checkNameAvailabilityInput, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityOutputInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CdnManagementClientImpl.this.checkNameAvailabilityWithSubscriptionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityOutputInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ValidateProbeOutputInner validateProbe(String probeURL) {
        return (ValidateProbeOutputInner)((ServiceResponse)this.validateProbeWithServiceResponseAsync(probeURL).toBlocking().single()).body();
    }

    public ServiceFuture<ValidateProbeOutputInner> validateProbeAsync(String probeURL, ServiceCallback<ValidateProbeOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateProbeWithServiceResponseAsync(probeURL), serviceCallback);
    }

    public Observable<ValidateProbeOutputInner> validateProbeAsync(String probeURL) {
        return this.validateProbeWithServiceResponseAsync(probeURL).map((Func1)new Func1<ServiceResponse<ValidateProbeOutputInner>, ValidateProbeOutputInner>(){

            public ValidateProbeOutputInner call(ServiceResponse<ValidateProbeOutputInner> response) {
                return (ValidateProbeOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidateProbeOutputInner>> validateProbeWithServiceResponseAsync(String probeURL) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (probeURL == null) {
            throw new IllegalArgumentException("Parameter probeURL is required and cannot be null.");
        }
        ValidateProbeInput validateProbeInput = new ValidateProbeInput();
        validateProbeInput.withProbeURL(probeURL);
        return this.service.validateProbe(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), validateProbeInput, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateProbeOutputInner>>>(){

            public Observable<ServiceResponse<ValidateProbeOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CdnManagementClientImpl.this.validateProbeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ValidateProbeOutputInner> validateProbeDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<ValidateProbeOutputInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface CdnManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient checkNameAvailability"})
        @POST(value="providers/Microsoft.Cdn/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body CheckNameAvailabilityInput var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient checkNameAvailabilityWithSubscription"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailabilityWithSubscription(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CheckNameAvailabilityInput var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient validateProbe"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateProbe")
        public Observable<Response<ResponseBody>> validateProbe(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body ValidateProbeInput var4, @Header(value="User-Agent") String var5);
    }
}

