/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.ChannelCredentials;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.BootstrapperImpl;
import io.grpc.xds.ClientXdsClient;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsNameResolverProvider.XdsClientPoolFactory {
    private final Bootstrapper bootstrapper;
    private final Object lock = new Object();
    private final AtomicReference<Map<String, ?>> bootstrapOverride = new AtomicReference();
    private volatile ObjectPool<XdsClient> xdsClientPool;

    SharedXdsClientPoolProvider() {
        this(new BootstrapperImpl());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper) {
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    @Override
    public void setBootstrapOverride(Map<String, ?> bootstrap) {
        this.bootstrapOverride.set(bootstrap);
    }

    @Override
    @Nullable
    public ObjectPool<XdsClient> get() {
        return this.xdsClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectPool<XdsClient> getOrCreate() throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.xdsClientPool;
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.xdsClientPool;
                if (ref == null) {
                    Map<String, ?> rawBootstrap = this.bootstrapOverride.get();
                    Bootstrapper.BootstrapInfo bootstrapInfo = rawBootstrap != null ? this.bootstrapper.bootstrap(rawBootstrap) : this.bootstrapper.bootstrap();
                    if (bootstrapInfo.servers().isEmpty()) {
                        throw new XdsInitializationException("No xDS server provided");
                    }
                    ref = this.xdsClientPool = new RefCountedXdsClientObjectPool(bootstrapInfo);
                }
            }
        }
        return ref;
    }

    @ThreadSafe
    @VisibleForTesting
    static class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final Context context = Context.ROOT;
        private final Bootstrapper.BootstrapInfo bootstrapInfo;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private ManagedChannel channel;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;

        @VisibleForTesting
        RefCountedXdsClientObjectPool(Bootstrapper.BootstrapInfo bootstrapInfo) {
            this.bootstrapInfo = (Bootstrapper.BootstrapInfo)Preconditions.checkNotNull((Object)bootstrapInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.refCount == 0) {
                    Bootstrapper.ServerInfo serverInfo = (Bootstrapper.ServerInfo)this.bootstrapInfo.servers().get(0);
                    String target = serverInfo.target();
                    ChannelCredentials channelCredentials = serverInfo.channelCredentials();
                    this.channel = Grpc.newChannelBuilder((String)target, (ChannelCredentials)channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES).build();
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
                    this.xdsClient = new ClientXdsClient(this.channel, this.bootstrapInfo, this.context, this.scheduler, (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER, TimeProvider.SYSTEM_TIME_PROVIDER, new TlsContextManagerImpl(this.bootstrapInfo));
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.channel.shutdown();
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.scheduler);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        ManagedChannel getChannelForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.channel;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        XdsClient getXdsClientForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.xdsClient;
            }
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

