/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.IssuerParameters;
import com.microsoft.azure.keyvault.models.KeyProperties;
import com.microsoft.azure.keyvault.models.LifetimeAction;
import com.microsoft.azure.keyvault.models.SecretProperties;
import com.microsoft.azure.keyvault.models.X509CertificateProperties;
import java.util.ArrayList;

public final class UpdateCertificatePolicyRequest {
    private final String vaultBaseUrl;
    private final String certificateName;
    private final CertificatePolicy certificatePolicy;

    private UpdateCertificatePolicyRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.certificateName = builder.certificateName;
        if (builder.policy != null) {
            this.certificatePolicy = new CertificatePolicy();
            if (builder.policy.attributes() != null) {
                this.certificatePolicy.withAttributes((CertificateAttributes)new CertificateAttributes().withEnabled(builder.policy.attributes().enabled()).withExpires(builder.policy.attributes().expires()).withNotBefore(builder.policy.attributes().notBefore()));
            }
            if (builder.policy.issuerParameters() != null) {
                this.certificatePolicy.withIssuerParameters(new IssuerParameters().withName(builder.policy.issuerParameters().name()));
            }
            if (builder.policy.x509CertificateProperties() != null) {
                this.certificatePolicy.withX509CertificateProperties(new X509CertificateProperties().withValidityInMonths(builder.policy.x509CertificateProperties().validityInMonths()).withSubjectAlternativeNames(builder.policy.x509CertificateProperties().subjectAlternativeNames()).withSubject(builder.policy.x509CertificateProperties().subject()).withEkus(builder.policy.x509CertificateProperties().ekus()).withKeyUsage(builder.policy.x509CertificateProperties().keyUsage()));
            }
            if (builder.policy.lifetimeActions() != null) {
                this.certificatePolicy.withLifetimeActions(new ArrayList<LifetimeAction>(builder.policy.lifetimeActions()));
            }
            if (builder.policy.keyProperties() != null) {
                this.certificatePolicy.withKeyProperties(new KeyProperties().withExportable(builder.policy.keyProperties().exportable()).withKeySize(builder.policy.keyProperties().keySize()).withKeyType(builder.policy.keyProperties().keyType()).withReuseKey(builder.policy.keyProperties().reuseKey()));
            }
            if (builder.policy.secretProperties() != null) {
                this.certificatePolicy.withSecretProperties(new SecretProperties().withContentType(builder.policy.secretProperties().contentType()));
            }
        } else {
            this.certificatePolicy = new CertificatePolicy();
        }
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public CertificatePolicy certificatePolicy() {
        return this.certificatePolicy;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String certificateName;
        private CertificatePolicy policy;

        public Builder(String vaultBaseUrl, String certificateName) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.certificateName = certificateName;
        }

        public Builder withPolicy(CertificatePolicy certificatePolicy) {
            this.policy = certificatePolicy;
            return this;
        }

        public UpdateCertificatePolicyRequest build() {
            return new UpdateCertificatePolicyRequest(this);
        }
    }
}

