/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import rx.Observable;

@Beta(value=Beta.SinceVersion.V1_6_0)
@Fluent(ContainerName="/Microsoft.Azure.Management.Fluent.KeyVault")
public interface Key
extends Indexable,
HasInner<KeyBundle>,
HasId,
HasName,
Updatable<Update> {
    public JsonWebKey jsonWebKey();

    public KeyAttributes attributes();

    public Map<String, String> tags();

    public boolean managed();

    @Method
    public PagedList<Key> listVersions();

    @Method
    public Observable<Key> listVersionsAsync();

    @Method
    public byte[] backup();

    @Method
    public Observable<byte[]> backupAsync();

    public byte[] encrypt(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public Observable<byte[]> encryptAsync(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public byte[] decrypt(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public Observable<byte[]> decryptAsync(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public byte[] sign(JsonWebKeySignatureAlgorithm var1, byte[] var2);

    public Observable<byte[]> signAsync(JsonWebKeySignatureAlgorithm var1, byte[] var2);

    public boolean verify(JsonWebKeySignatureAlgorithm var1, byte[] var2, byte[] var3);

    public Observable<Boolean> verifyAsync(JsonWebKeySignatureAlgorithm var1, byte[] var2, byte[] var3);

    public byte[] wrapKey(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public Observable<byte[]> wrapKeyAsync(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public byte[] unwrapKey(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public Observable<byte[]> unwrapKeyAsync(JsonWebKeyEncryptionAlgorithm var1, byte[] var2);

    public static interface UpdateWithImport
    extends Update,
    UpdateStages.WithHsm {
    }

    public static interface UpdateWithCreate
    extends Update,
    UpdateStages.WithKeySize {
    }

    public static interface Update
    extends Appliable<Key>,
    UpdateStages.WithKey,
    UpdateStages.WithKeyOperations,
    UpdateStages.WithAttributes,
    UpdateStages.WithTags {
    }

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }

        public static interface WithAttributes {
            public Update withAttributes(Attributes var1);
        }

        public static interface WithKeyOperations {
            public Update withKeyOperations(List<JsonWebKeyOperation> var1);

            public Update withKeyOperations(JsonWebKeyOperation ... var1);
        }

        public static interface WithHsm {
            public UpdateWithImport withHsm(boolean var1);
        }

        public static interface WithKeySize {
            public UpdateWithCreate withKeySize(int var1);
        }

        public static interface WithKey {
            public UpdateWithCreate withKeyTypeToCreate(JsonWebKeyType var1);

            public UpdateWithImport withLocalKeyToImport(JsonWebKey var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithImport
        extends WithHsm,
        WithCreateBase {
        }

        public static interface WithCreate
        extends WithKeyOperations,
        WithKeySize,
        WithCreateBase {
        }

        public static interface WithCreateBase
        extends Creatable<Key>,
        WithAttributes,
        WithTags {
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithAttributes {
            public WithCreate withAttributes(Attributes var1);
        }

        public static interface WithHsm {
            public WithImport withHsm(boolean var1);
        }

        public static interface WithKeyOperations {
            public WithCreate withKeyOperations(List<JsonWebKeyOperation> var1);

            public WithCreate withKeyOperations(JsonWebKeyOperation ... var1);
        }

        public static interface WithKeySize {
            public WithCreate withKeySize(int var1);
        }

        public static interface WithKey {
            public WithCreate withKeyTypeToCreate(JsonWebKeyType var1);

            public WithImport withLocalKeyToImport(JsonWebKey var1);
        }

        public static interface Blank
        extends WithKey {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithKey,
    DefinitionStages.WithImport,
    DefinitionStages.WithCreate {
    }
}

