/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccounts;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBAccountsImpl;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_2_0)
public final class CosmosDBManager
extends Manager<CosmosDBManager, CosmosDBImpl> {
    private CosmosDBAccountsImpl databaseAccounts;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static CosmosDBManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new CosmosDBManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static CosmosDBManager authenticate(RestClient restClient, String subscriptionId) {
        return new CosmosDBManager(restClient, subscriptionId);
    }

    private CosmosDBManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new CosmosDBImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public CosmosDBAccounts databaseAccounts() {
        if (this.databaseAccounts == null) {
            this.databaseAccounts = new CosmosDBAccountsImpl(this);
        }
        return this.databaseAccounts;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public CosmosDBManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return CosmosDBManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public CosmosDBManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

