/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.containerservice.ContainerServiceAgentPool;
import com.microsoft.azure.management.containerservice.ContainerServiceMasterProfileCount;
import com.microsoft.azure.management.containerservice.ContainerServiceOrchestratorTypes;
import com.microsoft.azure.management.containerservice.ContainerServiceStorageProfileTypes;
import com.microsoft.azure.management.containerservice.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceInner;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;

@Fluent
@Beta(value=Beta.SinceVersion.V1_4_0)
public interface ContainerService
extends GroupableResource<ContainerServiceManager, ContainerServiceInner>,
Refreshable<ContainerService>,
Updatable<Update>,
OrchestratorServiceBase {
    public int masterNodeCount();

    public ContainerServiceOrchestratorTypes orchestratorType();

    public String masterDnsPrefix();

    public String masterFqdn();

    public Map<String, ContainerServiceAgentPool> agentPools();

    public String linuxRootUsername();

    public String sshKey();

    public boolean isDiagnosticsEnabled();

    public String servicePrincipalClientId();

    public String servicePrincipalSecret();

    public int masterOSDiskSizeInGB();

    public ContainerServiceStorageProfileTypes masterStorageProfile();

    public String masterSubnetName();

    public String networkId();

    public static interface UpdateStages {

        public static interface WithDiagnostics {
            public Update withDiagnostics();

            public Update withoutDiagnostics();
        }

        public static interface WithUpdateAgentPoolCount {
            public Update withAgentVirtualMachineCount(int var1);
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<ContainerService>,
    UpdateStages.WithUpdateAgentPoolCount,
    UpdateStages.WithDiagnostics {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithMasterDnsPrefix,
        WithDiagnostics,
        WithMasterVMSize,
        WithMasterStorageProfile,
        WithMasterOSDiskSize,
        WithSubnet,
        Creatable<ContainerService>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithSubnet {
            public WithCreate withSubnet(String var1, String var2);
        }

        public static interface WithMasterOSDiskSize {
            public WithCreate withMasterOSDiskSizeInGB(int var1);
        }

        public static interface WithMasterStorageProfile {
            public WithCreate withMasterStorageProfile(ContainerServiceStorageProfileTypes var1);
        }

        public static interface WithMasterVMSize {
            public WithCreate withMasterVMSize(ContainerServiceVMSizeTypes var1);
        }

        public static interface WithDiagnostics {
            public WithCreate withDiagnostics();
        }

        public static interface WithMasterDnsPrefix {
            public WithCreate withMasterDnsPrefix(String var1);
        }

        public static interface WithAgentPool {
            public ContainerServiceAgentPool.DefinitionStages.Blank<WithCreate> defineAgentPool(String var1);
        }

        public static interface WithMasterNodeCount {
            public WithAgentPool withMasterNodeCount(ContainerServiceMasterProfileCount var1);
        }

        public static interface WithLinuxSshKey {
            public WithMasterNodeCount withSshKey(String var1);
        }

        public static interface WithLinuxRootUsername {
            public WithLinuxSshKey withRootUsername(String var1);
        }

        public static interface WithLinux {
            @Method
            public WithLinuxRootUsername withLinux();
        }

        public static interface WithServicePrincipalProfile {
            public WithLinux withServicePrincipal(String var1, String var2);
        }

        public static interface WithOrchestrator {
            public WithLinux withSwarmOrchestration();

            public WithLinux withDcosOrchestration();

            public WithServicePrincipalProfile withKubernetesOrchestration();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithOrchestrator> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithOrchestrator,
    DefinitionStages.WithMasterNodeCount,
    DefinitionStages.WithLinux,
    DefinitionStages.WithLinuxRootUsername,
    DefinitionStages.WithLinuxSshKey,
    DefinitionStages.WithAgentPool,
    DefinitionStages.WithServicePrincipalProfile,
    DefinitionStages.WithCreate {
    }
}

