/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.RouteTable;
import com.microsoft.azure.management.network.ServiceEndpointType;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Fluent
public interface Subnet
extends HasInner<SubnetInner>,
ChildResource<Network> {
    @Deprecated
    @Method
    public Set<NicIPConfiguration> getNetworkInterfaceIPConfigurations();

    @Method
    public Collection<NicIPConfiguration> listNetworkInterfaceIPConfigurations();

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public Set<String> listAvailablePrivateIPAddresses();

    public int networkInterfaceIPConfigurationCount();

    public String addressPrefix();

    public NetworkSecurityGroup getNetworkSecurityGroup();

    public String networkSecurityGroupId();

    public RouteTable getRouteTable();

    public String routeTableId();

    @Beta(value=Beta.SinceVersion.V1_6_0)
    public Map<ServiceEndpointType, List<Region>> servicesWithAccess();

    public static interface UpdateDefinition<ParentT>
    extends UpdateDefinitionStages.Blank<ParentT>,
    UpdateDefinitionStages.WithAddressPrefix<ParentT>,
    UpdateDefinitionStages.WithNetworkSecurityGroup<ParentT>,
    UpdateDefinitionStages.WithAttach<ParentT> {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InUpdate<ParentT>,
        WithNetworkSecurityGroup<ParentT>,
        WithRouteTable<ParentT>,
        WithServiceEndpoint<ParentT> {
        }

        @Beta(value=Beta.SinceVersion.V1_6_0)
        public static interface WithServiceEndpoint<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_6_0)
            public WithAttach<ParentT> withAccessFromService(ServiceEndpointType var1);
        }

        public static interface WithRouteTable<ParentT> {
            public WithAttach<ParentT> withExistingRouteTable(RouteTable var1);

            public WithAttach<ParentT> withExistingRouteTable(String var1);
        }

        public static interface WithNetworkSecurityGroup<ParentT> {
            public WithAttach<ParentT> withExistingNetworkSecurityGroup(String var1);

            public WithAttach<ParentT> withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithAddressPrefix<ParentT> {
            public WithAttach<ParentT> withAddressPrefix(String var1);
        }

        public static interface Blank<ParentT>
        extends WithAddressPrefix<ParentT> {
        }
    }

    public static interface Update
    extends UpdateStages.WithAddressPrefix,
    UpdateStages.WithNetworkSecurityGroup,
    UpdateStages.WithRouteTable,
    UpdateStages.WithServiceEndpoint,
    Settable<Network.Update> {
    }

    public static interface UpdateStages {

        @Beta(value=Beta.SinceVersion.V1_6_0)
        public static interface WithServiceEndpoint {
            @Beta(value=Beta.SinceVersion.V1_6_0)
            public Update withAccessFromService(ServiceEndpointType var1);

            @Beta(value=Beta.SinceVersion.V1_6_0)
            public Update withoutAccessFromService(ServiceEndpointType var1);
        }

        public static interface WithRouteTable {
            public Update withExistingRouteTable(RouteTable var1);

            public Update withExistingRouteTable(String var1);

            public Update withoutRouteTable();
        }

        public static interface WithNetworkSecurityGroup {
            public Update withExistingNetworkSecurityGroup(String var1);

            public Update withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);

            public Update withoutNetworkSecurityGroup();
        }

        public static interface WithAddressPrefix {
            public Update withAddressPrefix(String var1);
        }
    }

    public static interface Definition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithAddressPrefix<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends Attachable.InDefinition<ParentT>,
        WithNetworkSecurityGroup<ParentT>,
        WithRouteTable<ParentT>,
        WithServiceEndpoint<ParentT> {
        }

        @Beta(value=Beta.SinceVersion.V1_6_0)
        public static interface WithServiceEndpoint<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_6_0)
            public WithAttach<ParentT> withAccessFromService(ServiceEndpointType var1);
        }

        public static interface WithRouteTable<ParentT> {
            public WithAttach<ParentT> withExistingRouteTable(RouteTable var1);

            public WithAttach<ParentT> withExistingRouteTable(String var1);
        }

        public static interface WithNetworkSecurityGroup<ParentT> {
            public WithAttach<ParentT> withExistingNetworkSecurityGroup(String var1);

            public WithAttach<ParentT> withExistingNetworkSecurityGroup(NetworkSecurityGroup var1);
        }

        public static interface WithAddressPrefix<ParentT> {
            public WithAttach<ParentT> withAddressPrefix(String var1);
        }

        public static interface Blank<ParentT>
        extends WithAddressPrefix<ParentT> {
        }
    }
}

