/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.io.BaseEncoding;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServiceCertificate;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrder;
import com.microsoft.azure.management.appservice.HostNameSslBinding;
import com.microsoft.azure.management.appservice.HostNameSslState;
import com.microsoft.azure.management.appservice.SslState;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class HostNameSslBindingImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<HostNameSslState>
implements HostNameSslBinding,
HostNameSslBinding.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
HostNameSslBinding.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private Observable<AppServiceCertificate> newCertificate;
    private AppServiceCertificateOrder.DefinitionStages.WithKeyVault certificateInDefinition;
    private final FluentImplT parent;

    HostNameSslBindingImpl(HostNameSslState inner, FluentImplT parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public String name() {
        return ((HostNameSslState)this.inner()).name();
    }

    @Override
    public SslState sslState() {
        return ((HostNameSslState)this.inner()).sslState();
    }

    @Override
    public String virtualIP() {
        return ((HostNameSslState)this.inner()).virtualIP();
    }

    @Override
    public String thumbprint() {
        return ((HostNameSslState)this.inner()).thumbprint();
    }

    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent).withNewHostNameSslBinding(this);
        return this.parent;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withPfxCertificateToUpload(File pfxFile, String password) {
        String thumbprint = this.getCertificateThumbprint(pfxFile.getPath(), password);
        this.newCertificate = Utils.rootResource((Observable)((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)((AppServiceManager)((Object)this.parent().manager())).certificates().define(this.getCertificateUniqueName(thumbprint, this.parent().region()))).withRegion(this.parent().region())).withExistingResourceGroup(this.parent().resourceGroupName())).withPfxFile(pfxFile).withPfxPassword(password).createAsync());
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withExistingCertificate(final String certificateNameOrThumbprint) {
        this.newCertificate = ((AppServiceManager)((Object)this.parent().manager())).certificates().listByResourceGroupAsync(this.parent().resourceGroupName()).toList().map((Func1)new Func1<List<AppServiceCertificate>, AppServiceCertificate>(){

            public AppServiceCertificate call(List<AppServiceCertificate> appServiceCertificates) {
                for (AppServiceCertificate certificate : appServiceCertificates) {
                    if (!certificate.name().equals(certificateNameOrThumbprint) && !certificate.thumbprint().equalsIgnoreCase(certificateNameOrThumbprint)) continue;
                    return certificate;
                }
                return null;
            }
        }).map((Func1)new Func1<AppServiceCertificate, AppServiceCertificate>(){

            public AppServiceCertificate call(AppServiceCertificate appServiceCertificate) {
                if (appServiceCertificate != null) {
                    HostNameSslBindingImpl.this.withCertificateThumbprint(certificateNameOrThumbprint);
                }
                return appServiceCertificate;
            }
        });
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withNewStandardSslCertificateOrder(String certificateOrderName) {
        this.certificateInDefinition = ((AppServiceCertificateOrder.DefinitionStages.WithHostName)((AppServiceCertificateOrder.DefinitionStages.Blank)((AppServiceManager)((Object)this.parent().manager())).certificateOrders().define(certificateOrderName)).withExistingResourceGroup(this.parent().resourceGroupName())).withHostName(this.name()).withStandardSku().withWebAppVerification(this.parent());
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withExistingAppServiceCertificateOrder(AppServiceCertificateOrder certificateOrder) {
        Observable resourceStream = ((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)((AppServiceManager)((Object)this.parent().manager())).certificates().define(this.getCertificateUniqueName(certificateOrder.signedCertificate().thumbprint(), this.parent().region()))).withRegion(this.parent().region())).withExistingResourceGroup(this.parent().resourceGroupName())).withExistingCertificateOrder(certificateOrder).createAsync();
        this.newCertificate = Utils.rootResource((Observable)resourceStream);
        return this;
    }

    private HostNameSslBindingImpl<FluentT, FluentImplT> withCertificateThumbprint(String thumbprint) {
        ((HostNameSslState)this.inner()).withThumbprint(thumbprint);
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withSniBasedSsl() {
        ((HostNameSslState)this.inner()).withSslState(SslState.SNI_ENABLED);
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withIpBasedSsl() {
        ((HostNameSslState)this.inner()).withSslState(SslState.IP_BASED_ENABLED);
        return this;
    }

    Observable<AppServiceCertificate> newCertificate() {
        return this.newCertificate.doOnNext((Action1)new Action1<AppServiceCertificate>(){

            public void call(AppServiceCertificate appServiceCertificate) {
                if (appServiceCertificate != null) {
                    HostNameSslBindingImpl.this.withCertificateThumbprint(appServiceCertificate.thumbprint());
                }
            }
        });
    }

    public WebAppBase parent() {
        return this.parent;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> forHostname(String hostname) {
        ((HostNameSslState)this.inner()).withName(hostname);
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withExistingKeyVault(Vault vault) {
        Observable appServiceCertificateOrderObservable = Utils.rootResource((Observable)this.certificateInDefinition.withExistingKeyVault(vault).createAsync());
        final AppServiceManager manager = (AppServiceManager)((Object)this.parent().manager());
        this.newCertificate = appServiceCertificateOrderObservable.flatMap((Func1)new Func1<AppServiceCertificateOrder, Observable<AppServiceCertificate>>(){

            public Observable<AppServiceCertificate> call(AppServiceCertificateOrder appServiceCertificateOrder) {
                return Utils.rootResource((Observable)((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)manager.certificates().define(appServiceCertificateOrder.name())).withRegion(HostNameSslBindingImpl.this.parent().regionName())).withExistingResourceGroup(HostNameSslBindingImpl.this.parent().resourceGroupName())).withExistingCertificateOrder(appServiceCertificateOrder).createAsync());
            }
        });
        return this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> withNewKeyVault(String vaultName) {
        Observable appServiceCertificateOrderObservable = Utils.rootResource((Observable)this.certificateInDefinition.withNewKeyVault(vaultName, this.parent().region()).createAsync());
        final AppServiceManager manager = (AppServiceManager)((Object)this.parent().manager());
        this.newCertificate = appServiceCertificateOrderObservable.flatMap((Func1)new Func1<AppServiceCertificateOrder, Observable<AppServiceCertificate>>(){

            public Observable<AppServiceCertificate> call(AppServiceCertificateOrder appServiceCertificateOrder) {
                return Utils.rootResource((Observable)((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)manager.certificates().define(appServiceCertificateOrder.name())).withRegion(HostNameSslBindingImpl.this.parent().regionName())).withExistingResourceGroup(HostNameSslBindingImpl.this.parent().resourceGroupName())).withExistingCertificateOrder(appServiceCertificateOrder).createAsync());
            }
        });
        return this;
    }

    private String getCertificateThumbprint(String pfxPath, String password) {
        try {
            FileInputStream inStream = new FileInputStream(pfxPath);
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(inStream, password.toCharArray());
            String alias = ks.aliases().nextElement();
            X509Certificate certificate = (X509Certificate)ks.getCertificate(alias);
            ((InputStream)inStream).close();
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            return BaseEncoding.base16().encode(sha.digest(certificate.getEncoded()));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getCertificateUniqueName(String thumbprint, Region region) {
        return String.format("%s##%s#", thumbprint, region.label());
    }
}

