/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.LangMethodDefinition;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.monitor.DiagnosticSettingsCategory;
import com.microsoft.azure.management.monitor.LogSettings;
import com.microsoft.azure.management.monitor.MetricSettings;
import com.microsoft.azure.management.monitor.implementation.DiagnosticSettingsResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import org.joda.time.Period;

@Beta(value=Beta.SinceVersion.V1_8_0)
@Fluent
public interface DiagnosticSetting
extends Indexable,
HasId,
HasName,
HasManager<MonitorManager>,
HasInner<DiagnosticSettingsResourceInner>,
Refreshable<DiagnosticSetting>,
Updatable<Update> {
    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String resourceId();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String storageAccountId();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String eventHubAuthorizationRuleId();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String eventHubName();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public List<MetricSettings> metrics();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public List<LogSettings> logs();

    @LangMethodDefinition(AsType=LangMethodDefinition.LangMethodType.Property)
    public String workspaceId();

    public static interface Update
    extends Appliable<DiagnosticSetting>,
    UpdateStages.WithStorageAccount,
    UpdateStages.WithEventHub,
    UpdateStages.WithLogAnalytics,
    UpdateStages.WithMetricAndLogs {
    }

    public static interface UpdateStages {

        public static interface WithMetricAndLogs {
            public Update withMetric(String var1, Period var2, int var3);

            public Update withLog(String var1, int var2);

            public Update withLogsAndMetrics(List<DiagnosticSettingsCategory> var1, Period var2, int var3);

            public Update withoutMetric(String var1);

            public Update withoutLog(String var1);

            @Method
            public Update withoutLogs();

            @Method
            public Update withoutMetrics();
        }

        public static interface WithLogAnalytics {
            public Update withLogAnalytics(String var1);

            @Method
            public Update withoutLogAnalytics();
        }

        public static interface WithEventHub {
            public Update withEventHub(String var1);

            public Update withEventHub(String var1, String var2);

            @Method
            public Update withoutEventHub();
        }

        public static interface WithStorageAccount {
            public Update withStorageAccount(String var1);

            @Method
            public Update withoutStorageAccount();
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithDiagnosticLogRecipient,
        Creatable<DiagnosticSetting> {
            public WithCreate withMetric(String var1, Period var2, int var3);

            public WithCreate withLog(String var1, int var2);

            public WithCreate withLogsAndMetrics(List<DiagnosticSettingsCategory> var1, Period var2, int var3);
        }

        public static interface WithDiagnosticLogRecipient {
            public WithCreate withLogAnalytics(String var1);

            public WithCreate withStorageAccount(String var1);

            public WithCreate withEventHub(String var1);

            public WithCreate withEventHub(String var1, String var2);
        }

        public static interface Blank {
            public WithDiagnosticLogRecipient withResource(String var1);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithDiagnosticLogRecipient,
    DefinitionStages.WithCreate {
    }
}

