/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRule;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRuleOperations;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.VirtualNetworkRuleInner;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlVirtualNetworkRuleImpl
extends ExternalChildResourceImpl<SqlVirtualNetworkRule, VirtualNetworkRuleInner, SqlServerImpl, SqlServer>
implements SqlVirtualNetworkRule,
SqlVirtualNetworkRule.SqlVirtualNetworkRuleDefinition<SqlServer.DefinitionStages.WithCreate>,
SqlVirtualNetworkRule.Update,
SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlVirtualNetworkRuleImpl(String name, SqlServerImpl parent, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlVirtualNetworkRuleImpl(String resourceGroupName, String sqlServerName, String name, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlVirtualNetworkRuleImpl(String name, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    public Observable<SqlVirtualNetworkRule> createResourceAsync() {
        final SqlVirtualNetworkRuleImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (VirtualNetworkRuleInner)this.inner()).map((Func1)new Func1<VirtualNetworkRuleInner, SqlVirtualNetworkRule>(){

            public SqlVirtualNetworkRule call(VirtualNetworkRuleInner inner) {
                self.setInner(inner);
                return self;
            }
        });
    }

    public Observable<SqlVirtualNetworkRule> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    protected Observable<VirtualNetworkRuleInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).virtualNetworkRules().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public SqlVirtualNetworkRuleImpl update() {
        super.prepareUpdate();
        return this;
    }

    public String id() {
        return ((VirtualNetworkRuleInner)this.inner()).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String subnetId() {
        return ((VirtualNetworkRuleInner)this.inner()).virtualNetworkSubnetId();
    }

    @Override
    public String state() {
        return ((VirtualNetworkRuleInner)this.inner()).state().toString();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public void delete() {
        this.deleteResourceAsync().toBlocking().last();
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withSubnet(String networkId, String subnetName) {
        ((VirtualNetworkRuleInner)this.inner()).withVirtualNetworkSubnetId(networkId + "/subnets/" + subnetName);
        ((VirtualNetworkRuleInner)this.inner()).withIgnoreMissingVnetServiceEndpoint(false);
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl ignoreMissingSqlServiceEndpoint() {
        ((VirtualNetworkRuleInner)this.inner()).withIgnoreMissingVnetServiceEndpoint(true);
        return this;
    }

    public SqlServer.DefinitionStages.WithCreate attach() {
        return (SqlServer.DefinitionStages.WithCreate)this.parent();
    }
}

